/*
 * Decompiled with CFR 0.152.
 */
package ts;

import java.sql.SQLException;
import prihlasovanie.DbContext;
import rdg.NajdiTiket;
import rdg.NajdiUdalost;
import rdg.NajdiUzivatela;
import rdg.Tiket;
import rdg.Udalosti;
import rdg.Uzivatelia;
import ts.TiketException;

public class TiketVloz {
    private static final TiketVloz INSTANCE = new TiketVloz();

    public static TiketVloz getInstance() {
        return INSTANCE;
    }

    public boolean vloz(int id_udalost, Integer tip, int id_uzivatel, int cislo_tiketu) throws TiketException, SQLException {
        if (tip == null) {
            throw new IllegalArgumentException("Tip nesmie byt null");
        }
        DbContext.getConnection().setTransactionIsolation(8);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Udalosti udalost = NajdiUdalost.getInstance().findById(id_udalost);
            if (udalost == null) {
                throw new TiketException("Taka udalost neexistuje");
            }
            Tiket tiket = new Tiket();
            Uzivatelia uzivatel = NajdiUzivatela.getInstance().findById(id_uzivatel);
            if (uzivatel == null) {
                throw new TiketException("Taky uzivatel neexistuje");
            }
            if (NajdiTiket.getInstance().findUdalost(id_udalost, id_uzivatel)) {
                System.out.println("Udalost nebola pridana lebo uz je na tikete");
                boolean bl = false;
                return bl;
            }
            tiket.setIdUzivatel(id_uzivatel);
            tiket.setIdUdalost(id_udalost);
            tiket.setTip(tip);
            tiket.setPodany(0);
            tiket.setCisloTiketu(uzivatel.getCisloTiketu());
            tiket.insert();
            DbContext.getConnection().commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException | TiketException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }
}

