/*
 * Decompiled with CFR 0.152.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.Bookmakers;
import rdg.NajdiBookmaker;
import rdg.NajdiPocetGolov;
import rdg.NajdiUdalost;
import rdg.NajdiUmiestnenie;
import rdg.NajdiZapas;
import rdg.PocetGolovKurzy;
import rdg.Udalosti;
import rdg.UmiestnenieKurzy;
import rdg.ZapasKurzy;
import user.KurzyPocetGolovPrinter;
import user.KurzyUmiestneniePrinter;
import user.KurzyZapasPrinter;
import user.Menu;
import user.PonukaPrinter;

public class MenuBookmaker
extends Menu {
    private final Integer id;

    MenuBookmaker(Integer id) {
        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. vylistovat ponuku          *");
        System.out.println("* 2. pridat udalost             *");
        System.out.println("* 3. pocet zetonov             *");
        System.out.println("* 4. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1": {
                    this.listPonuka();
                    break;
                }
                case "2": {
                    this.pridatUdalost();
                    break;
                }
                case "3": {
                    this.zetony();
                    break;
                }
                case "4": {
                    this.exit();
                    break;
                }
                default: {
                    System.out.println("Unknown option");
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException | ParseException ex) {
            Logger.getLogger(MenuBookmaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void listPonuka() {
        try {
            for (Udalosti udalost : NajdiUdalost.getInstance().findAktualne()) {
                PonukaPrinter.getInstance().print(udalost);
                if (NajdiZapas.getInstance().findByIdBool(udalost.getId())) {
                    KurzyZapasPrinter.getInstance().print(udalost.getId());
                }
                if (NajdiUmiestnenie.getInstance().findByIdBool(udalost.getId())) {
                    KurzyUmiestneniePrinter.getInstance().print(udalost.getId());
                }
                if (!NajdiPocetGolov.getInstance().findByIdBool(udalost.getId())) continue;
                KurzyPocetGolovPrinter.getInstance().print(udalost.getId());
            }
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }

    private void pridatUdalost() throws IOException, ParseException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Zadajte aky typ udalosti chcete vytvorit");
        System.out.println("1 = zapas");
        System.out.println("2 = pocet golov");
        System.out.println("3 = umiestnenie");
        int volba = Integer.parseInt(br.readLine());
        Udalosti udalost = new Udalosti();
        System.out.print("zadaj datum konania(yyyy-MM-dd HH:mm:ss): ");
        String str = br.readLine();
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = simpleDateFormat.parse(str);
        Timestamp konanie = new Timestamp(date.getTime());
        udalost.setDatumKonania(konanie);
        System.out.print("zadaj datum konca stavkovania(yyyy-MM-dd HH:mm:ss): ");
        String s = br.readLine();
        Date den = simpleDateFormat.parse(s);
        Timestamp koniec = new Timestamp(den.getTime());
        udalost.setKoniecStavkovania(koniec);
        udalost.setIdBookmaker(this.id);
        udalost.setPocetPodani(0);
        udalost.insert();
        Bookmakers bookmaker = new Bookmakers();
        bookmaker.setId(this.id);
        bookmaker.setZetony(NajdiBookmaker.getInstance().findById(this.id).getZetony() + 1);
        bookmaker.navys();
        if (volba == 1) {
            ZapasKurzy zapas = new ZapasKurzy();
            zapas.setIdUdalost(udalost.getId());
            System.out.print("meno domacich: ");
            zapas.setDomaci(br.readLine());
            System.out.print("meno hosti: ");
            zapas.setHostia(br.readLine());
            System.out.print("kurz domaci: ");
            zapas.setDom(Double.parseDouble(br.readLine()));
            System.out.print("kurz remiza: ");
            zapas.setRem(Double.parseDouble(br.readLine()));
            System.out.print("kurz hostia: ");
            zapas.setHos(Double.parseDouble(br.readLine()));
            zapas.insert();
        } else if (volba == 2) {
            PocetGolovKurzy pocet = new PocetGolovKurzy();
            pocet.setIdUdalost(udalost.getId());
            System.out.print("meno domacich: ");
            pocet.setDomaci(br.readLine());
            System.out.print("meno hosti: ");
            pocet.setHostia(br.readLine());
            System.out.print("kurz 0-1: ");
            pocet.setNajviacJeden(Double.parseDouble(br.readLine()));
            System.out.print("kurz 2-3: ");
            pocet.setDvaTri(Double.parseDouble(br.readLine()));
            System.out.print("kurz 4-5: ");
            pocet.setStyriPat(Double.parseDouble(br.readLine()));
            System.out.print("kurz >5: ");
            pocet.setViacakoPat(Double.parseDouble(br.readLine()));
            pocet.insert();
        } else if (volba == 3) {
            UmiestnenieKurzy umiestnenie = new UmiestnenieKurzy();
            umiestnenie.setIdUdalost(udalost.getId());
            System.out.print("meno sutaziaceho: ");
            umiestnenie.setSutaziaci(br.readLine());
            System.out.print("kurz prvy: ");
            umiestnenie.setPrvy(Double.parseDouble(br.readLine()));
            System.out.print("kurz do tretieho: ");
            umiestnenie.setDoTri(Double.parseDouble(br.readLine()));
            System.out.print("kurz do piateho: ");
            umiestnenie.setDoPat(Double.parseDouble(br.readLine()));
            umiestnenie.insert();
        }
        System.out.println();
        System.out.print("Udalost bola uspesne vytvorena");
    }

    private void zetony() throws SQLException {
        System.out.println("Zetony:       " + NajdiBookmaker.getInstance().findById(this.id).getZetony());
    }
}

