/*
 * Decompiled with CFR 0.152.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.Bookmakers;
import rdg.Kancelaria;
import rdg.NajdiBookmaker;
import rdg.NajdiKancelaria;
import rdg.NajdiUzivatela;
import rdg.Uzivatelia;
import user.MainMenu;
import user.Menu;
import user.MenuBookmaker;
import user.MenuKancelaria;

public class prihlasovanie
extends Menu {
    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. prihlasenie                *");
        System.out.println("* 2. registracia                *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1": {
                    this.prihlas();
                    break;
                }
                case "2": {
                    this.registruj();
                    break;
                }
                case "3": {
                    this.exit();
                    break;
                }
                default: {
                    System.out.println("Unknown option");
                    break;
                }
            }
        }
        catch (IOException | SQLException | ParseException ex) {
            Logger.getLogger(prihlasovanie.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void prihlas() {
        try {
            System.out.println("******************");
            System.out.println("*  prihlasenie   *");
            System.out.println("******************");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("zadaj login: ");
            String log = br.readLine();
            Uzivatelia z = NajdiUzivatela.getInstance().findByLogin(log);
            Bookmakers b = NajdiBookmaker.getInstance().findByLogin(log);
            Kancelaria k = NajdiKancelaria.getInstance().findByLogin(log);
            if (z == null && b == null && k == null) {
                System.out.println("Zakaznik s takymto loginom neexistuje");
            } else {
                System.out.print("zadaj heslo: ");
                String heslo = br.readLine();
                if (NajdiUzivatela.getInstance().findByLoginBool(log) && !z.getHeslo().equals(heslo)) {
                    System.out.println("nespravne heslo");
                } else if (NajdiBookmaker.getInstance().findByLoginBool(log) && !b.getHeslo().equals(heslo)) {
                    System.out.println("nespravne heslo");
                } else if (NajdiKancelaria.getInstance().findByLoginBool(log) && !k.getHeslo().equals(heslo)) {
                    System.out.println("nespravne heslo");
                } else if (NajdiBookmaker.getInstance().findByLoginBool(log) && b.getBookmaker()) {
                    System.out.print("Vitajte " + b.getMeno());
                    MenuBookmaker bookmaker = new MenuBookmaker(b.getId());
                    bookmaker.run();
                } else if (NajdiKancelaria.getInstance().findByLoginBool(log) && k.getKancelaria()) {
                    System.out.print("Kancelaria");
                    MenuKancelaria kancelaria = new MenuKancelaria(k.getId());
                    kancelaria.run();
                } else if (NajdiUzivatela.getInstance().findByLoginBool(log) && z.getUzivatel()) {
                    System.out.print("Vitajte " + z.getMeno());
                    MainMenu menu = new MainMenu(z.getId());
                    menu.run();
                }
            }
        }
        catch (IOException | SQLException ex) {
            System.out.println("Uzivatel s tymto menom neexistuje");
            System.out.println("Registracia");
        }
    }

    private void registruj() throws IOException, SQLException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Uzivatelia c = new Uzivatelia();
        System.out.print("zadaj login: ");
        String log = br.readLine();
        Uzivatelia z = NajdiUzivatela.getInstance().findByLogin(log);
        if (z != null) {
            System.out.print("Uzivatel s takymto loginom uz existuje");
        } else {
            System.out.print("zadaj login este raz: ");
            c.setLogin(br.readLine());
            System.out.print("zadaj heslo: ");
            c.setHeslo(br.readLine());
            System.out.print("zadaj meno: ");
            c.setMeno(br.readLine());
            System.out.print("zadaj priezvisko: ");
            c.setPriezvisko(br.readLine());
            System.out.print("zadaj email: ");
            c.setEmail(br.readLine());
            System.out.print("zadaj datum nar. (2018-04-24): ");
            String str = br.readLine();
            String pattern = "yyyy-MM-dd";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            Date date = simpleDateFormat.parse(str);
            Timestamp narodenie = new Timestamp(date.getTime());
            c.setNarodenie(narodenie);
            c.setKredit(0);
            c.setBod(0);
            c.insert();
            c.setUzivatel(true);
            System.out.println("Novy uzivatel bol vytvoreny");
            System.out.print("Vase ID je: ");
            System.out.println(c.getId());
            this.prihlas();
        }
    }
}

