/*
 * Decompiled with CFR 0.152.
 */
package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import prihlasovanie.DbContext;

public abstract class BaseGateway {
    protected void insert(String sql) throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql, 1);){
            this.insertFill(s);
            s.executeUpdate();
            try (ResultSet r = s.getGeneratedKeys();){
                r.next();
                this.insertUpdateKeys(r);
            }
        }
    }

    protected abstract void insertFill(PreparedStatement var1) throws SQLException;

    protected abstract void insertUpdateKeys(ResultSet var1) throws SQLException;

    protected void update(String sql) throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql);){
            this.updateFill(s);
            s.executeUpdate();
        }
    }

    protected abstract void updateFill(PreparedStatement var1) throws SQLException;

    public void delete(String sql) throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql);){
            this.deleteFill(s);
            s.executeUpdate();
        }
    }

    protected abstract void deleteFill(PreparedStatement var1) throws SQLException;
}

