/*
 * Decompiled with CFR 0.152.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import rdg.BaseFinder;
import rdg.PocetGolovKurzy;

public class NajdiPocetGolov
extends BaseFinder<PocetGolovKurzy> {
    private static final NajdiPocetGolov INSTANCE = new NajdiPocetGolov();

    public static NajdiPocetGolov getInstance() {
        return INSTANCE;
    }

    private NajdiPocetGolov() {
    }

    public List<PocetGolovKurzy> findNeAktualne() {
        try {
            return this.findAll("SELECT * FROM pocetgolov INNER JOIN udalost ON pocetgolov.id_udalost=udalost.id  WHERE udalost.datum_konania<NOW() AND pocetgolov.spravne IS NULL");
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
            return null;
        }
    }

    public PocetGolovKurzy findById(int id) throws SQLException {
        return (PocetGolovKurzy)this.findByInt("SELECT * FROM pocetgolov WHERE id = ?", id);
    }

    public PocetGolovKurzy findByIdUdalosti(int id) throws SQLException {
        return (PocetGolovKurzy)this.findByInt("SELECT * FROM pocetgolov WHERE id_udalost = ?", id);
    }

    public boolean findByIdBool(int id) {
        try {
            return !((PocetGolovKurzy)this.findByInt("SELECT * FROM pocetgolov WHERE id_udalost = ?", id)).equals(null);
        }
        catch (NullPointerException | SQLException ex) {
            return false;
        }
    }

    public List<PocetGolovKurzy> findAll() throws SQLException {
        return this.findAll("SELECT * FROM pocetgolov");
    }

    @Override
    protected PocetGolovKurzy load(ResultSet r) throws SQLException {
        PocetGolovKurzy c = new PocetGolovKurzy();
        c.setId(r.getInt("id"));
        c.setIdUdalost(r.getInt("id_udalost"));
        c.setDomaci(r.getString("domaci"));
        c.setHostia(r.getString("hostia"));
        c.setNajviacJeden(r.getDouble("najviacjeden"));
        c.setDvaTri(r.getDouble("dvatri"));
        c.setStyriPat(r.getDouble("styripat"));
        c.setViacakoPat(r.getDouble("viacakopat"));
        c.setSpravne(r.getInt("spravne"));
        return c;
    }
}

