/*
 * Decompiled with CFR 0.152.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import rdg.BaseFinder;
import rdg.ZapasKurzy;

public class NajdiZapas
extends BaseFinder<ZapasKurzy> {
    private static final NajdiZapas INSTANCE = new NajdiZapas();

    public static NajdiZapas getInstance() {
        return INSTANCE;
    }

    private NajdiZapas() {
    }

    public List<ZapasKurzy> findNeAktualne() {
        try {
            return this.findAll("SELECT * FROM zapas INNER JOIN udalost ON zapas.id_udalost=udalost.id  WHERE udalost.datum_konania<NOW() AND zapas.spravne IS NULL");
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
            return null;
        }
    }

    public ZapasKurzy findById(int id) throws SQLException {
        return (ZapasKurzy)this.findByInt("SELECT * FROM zapas WHERE id = ?", id);
    }

    public ZapasKurzy findByIdUdalosti(int id) throws SQLException {
        return (ZapasKurzy)this.findByInt("SELECT * FROM zapas WHERE id_udalost = ?", id);
    }

    public boolean findByIdBool(int id) {
        try {
            return !((ZapasKurzy)this.findByInt("SELECT * FROM zapas WHERE id_udalost = ?", id)).equals(null);
        }
        catch (NullPointerException | SQLException ex) {
            return false;
        }
    }

    public List<ZapasKurzy> findAll() throws SQLException {
        return this.findAll("SELECT * FROM zapas");
    }

    @Override
    protected ZapasKurzy load(ResultSet r) throws SQLException {
        ZapasKurzy c = new ZapasKurzy();
        c.setId(r.getInt("id"));
        c.setIdUdalost(r.getInt("id_udalost"));
        c.setDomaci(r.getString("domaci"));
        c.setHostia(r.getString("hostia"));
        c.setDom(r.getDouble("dom"));
        c.setRem(r.getDouble("rem"));
        c.setHos(r.getDouble("hos"));
        c.setSpravne(r.getInt("spravne"));
        return c;
    }
}

