/*
 * Decompiled with CFR 0.152.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.NajdiOperacie;
import rdg.NajdiPocetGolov;
import rdg.NajdiTiket;
import rdg.NajdiUdalost;
import rdg.NajdiUmiestnenie;
import rdg.NajdiUzivatela;
import rdg.NajdiZapas;
import rdg.Operacie;
import rdg.Tiket;
import rdg.Udalosti;
import rdg.Uzivatelia;
import ts.TiketException;
import ts.TiketPotvrd;
import ts.TiketVloz;
import user.KurzyPocetGolovPrinter;
import user.KurzyUmiestneniePrinter;
import user.KurzyZapasPrinter;
import user.Menu;
import user.OperaciePrinter;
import user.PonukaPrinter;
import user.TiketPrinter;

public class MainMenu
extends Menu {
    private final Integer id;

    MainMenu(Integer id) {
        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. vylistovat ponuku          *");
        System.out.println("* 2. zobrazit posledne operacie *");
        System.out.println("* 3. pridat na tiket            *");
        System.out.println("* 4. odstranit z tiketu         *");
        System.out.println("* 5. zobrazit tiket             *");
        System.out.println("* 6. potvrdit tiket a zaplatit  *");
        System.out.println("* 7. zobrazit stav kreditu      *");
        System.out.println("* 8. vklad na konto             *");
        System.out.println("* 9. vyber z konta              *");
        System.out.println("* 10. zobrazit udaje o konte    *");
        System.out.println("* -11. zobrazit tikety           *");
        System.out.println("* 12. odstranit konto           *");
        System.out.println("* 13. odhlasit                  *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1": {
                    this.listPonuka();
                    break;
                }
                case "2": {
                    this.zobrazOperacie();
                    break;
                }
                case "3": {
                    this.pridatNaTiket();
                    break;
                }
                case "4": {
                    this.odstranitZTiketu();
                    break;
                }
                case "5": {
                    this.zobrazitTiket();
                    break;
                }
                case "6": {
                    this.potvrditTiket();
                    break;
                }
                case "7": {
                    this.stavKonta();
                    break;
                }
                case "8": {
                    this.vkladKreditu();
                    break;
                }
                case "9": {
                    this.vyberKreditu();
                    break;
                }
                case "10": {
                    this.mojeUdaje();
                    break;
                }
                case "11": {
                    this.zobrazitTikety();
                    break;
                }
                case "12": {
                    this.odstranitKonto();
                    break;
                }
                case "13": {
                    this.exit();
                    break;
                }
                default: {
                    System.out.println("Unknown option");
                    break;
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException | TiketException ex) {
            Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void listPonuka() {
        try {
            for (Udalosti udalost : NajdiUdalost.getInstance().findAktualne()) {
                PonukaPrinter.getInstance().print(udalost);
                if (NajdiZapas.getInstance().findByIdBool(udalost.getId())) {
                    KurzyZapasPrinter.getInstance().print(udalost.getId());
                }
                if (NajdiUmiestnenie.getInstance().findByIdBool(udalost.getId())) {
                    KurzyUmiestneniePrinter.getInstance().print(udalost.getId());
                }
                if (!NajdiPocetGolov.getInstance().findByIdBool(udalost.getId())) continue;
                KurzyPocetGolovPrinter.getInstance().print(udalost.getId());
            }
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }

    private void zobrazOperacie() throws SQLException {
        try {
            System.out.println("*****Vklady*****");
            for (Operacie operacia : NajdiOperacie.getInstance().findAllByIntVklad(this.id)) {
                OperaciePrinter.getInstance().print(operacia);
            }
        }
        catch (NullPointerException ex) {
            System.out.println();
        }
        try {
            System.out.println("*****Vybery*****");
            for (Operacie operacia : NajdiOperacie.getInstance().findAllByIntVyber(this.id)) {
                OperaciePrinter.getInstance().print(operacia);
            }
        }
        catch (NullPointerException ex) {
            System.out.println();
        }
    }

    private void stavKonta() throws SQLException {
        System.out.println("Stav vasho konta je: " + NajdiUzivatela.getInstance().findById(this.id).getKredit() + "\u20ac");
    }

    private void pridatNaTiket() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte id udalosti: ");
        Integer id = Integer.parseInt(br.readLine());
        System.out.print("Zadajte Vas tip: ");
        Integer tip = Integer.parseInt(br.readLine());
        boolean vysl = false;
        try {
            Uzivatelia ja = NajdiUzivatela.getInstance().findById(this.id);
            vysl = TiketVloz.getInstance().vloz(id, tip, ja.getId(), ja.getCisloTiketu());
        }
        catch (TiketException ex) {
            System.out.println(ex.getMessage());
        }
        if (vysl) {
            System.out.println("Udalost bola uspesne pridana na tiket");
        }
    }

    private void potvrditTiket() throws IOException, SQLException, ParseException, TiketException {
        System.out.print("Zadajte sumu za ktoru chcete vsadit tiket: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Integer suma = Integer.parseInt(br.readLine());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String datum = sdf.format(timestamp);
        Date date = sdf.parse(datum);
        Timestamp caspodania = new Timestamp(date.getTime());
        boolean vysl = true;
        Integer pocet = 0;
        Integer remizy = 0;
        double kurz = 1.0;
        if (NajdiUzivatela.getInstance().findById(this.id).getKredit() - suma >= 0) {
            Uzivatelia uzivatel = new Uzivatelia();
            uzivatel.setId(this.id);
            uzivatel.setMeno(NajdiUzivatela.getInstance().findById(this.id).getMeno());
            uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(this.id).getPriezvisko());
            uzivatel.setEmail(NajdiUzivatela.getInstance().findById(this.id).getEmail());
            uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(this.id).getNarodenie());
            uzivatel.setKredit(NajdiUzivatela.getInstance().findById(this.id).getKredit() - suma);
            uzivatel.update();
            for (Tiket tiket : NajdiTiket.getInstance().findNepodany(this.id)) {
                Integer n = pocet;
                Integer n2 = pocet = Integer.valueOf(pocet + 1);
                kurz *= tiket.getKurz();
                Integer id = tiket.getId();
                TiketPotvrd.getInstance().potvrd(id, timestamp, suma);
                if (tiket.getTip() != 0) continue;
                n2 = remizy;
                Integer n3 = remizy = Integer.valueOf(remizy + 1);
            }
            if (pocet == 0) {
                System.out.println("Tiket je prazdny");
                vysl = false;
            }
            if (pocet != 0 && kurz == 0.0) {
                System.out.println("Nepodarilo sa ziskat kurzy");
                vysl = false;
            }
        } else {
            System.out.println("Nedostatocny kredit na konte");
            vysl = false;
        }
        System.out.println("Celkovy kurz je: " + kurz);
        if (vysl) {
            if (pocet == 1) {
                System.out.println("Vas solo tiket bol uspesne podany");
            }
            if (pocet > 1 && pocet != remizy) {
                System.out.println("Vas akumulovany tiket bol uspesne podany");
            }
            if (pocet > 3 && pocet == remizy) {
                System.out.println("Vas tiket 'odvaha' bol uspesne podany");
            }
            System.out.println("Vyhra je " + (double)suma.intValue() * kurz);
        }
    }

    private void odstranitZTiketu() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte id z tiketu: ");
        int idk = Integer.parseInt(br.readLine());
        Tiket tiket = NajdiTiket.getInstance().findById(idk);
        if (tiket == null) {
            System.out.println("Taka udalost v tikete neexistuje");
        } else {
            tiket.delete();
            System.out.println("Udalost bola uspesne odstranena z tiketu");
        }
    }

    private void zobrazitTiket() {
        Integer pocet = 0;
        double kurz = 1.0;
        try {
            for (Tiket tiket : NajdiTiket.getInstance().findNepodany(this.id)) {
                Integer n = pocet;
                Integer n2 = pocet = Integer.valueOf(pocet + 1);
                TiketPrinter.getInstance().print(tiket);
                kurz *= tiket.getKurz();
            }
            if (pocet == 0) {
                System.out.println("Tiket je prazdny");
            }
            if (pocet != 0 && kurz == 0.0) {
                System.out.println("Nepodarilo sa ziskat kurzy");
            }
        }
        catch (SQLException ex) {
            System.out.println("tiket je prazdny");
        }
        System.out.println("Celkovy kurz je: " + kurz);
    }

    private void mojeUdaje() throws SQLException {
        System.out.println("Id:         " + NajdiUzivatela.getInstance().findById(this.id).getId());
        System.out.println("Meno:       " + NajdiUzivatela.getInstance().findById(this.id).getMeno());
        System.out.println("Priezvisko: " + NajdiUzivatela.getInstance().findById(this.id).getPriezvisko());
        System.out.println("Email:      " + NajdiUzivatela.getInstance().findById(this.id).getEmail());
        System.out.println("Narodenie:  " + NajdiUzivatela.getInstance().findById(this.id).getNarodenie());
        System.out.println("Body:       " + NajdiUzivatela.getInstance().findById(this.id).getBod());
    }

    private void vkladKreditu() throws SQLException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte kolko chcete dobit na konto: ");
        try {
            int suma = Integer.parseInt(br.readLine());
            Uzivatelia uzivatel = new Uzivatelia();
            uzivatel.setId(this.id);
            uzivatel.setMeno(NajdiUzivatela.getInstance().findById(this.id).getMeno());
            uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(this.id).getPriezvisko());
            uzivatel.setEmail(NajdiUzivatela.getInstance().findById(this.id).getEmail());
            uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(this.id).getNarodenie());
            uzivatel.setKredit(NajdiUzivatela.getInstance().findById(this.id).getKredit() + suma);
            uzivatel.update();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String datum = sdf.format(timestamp);
            Date date = sdf.parse(datum);
            Timestamp vysl = new Timestamp(date.getTime());
            Operacie operacia = new Operacie();
            operacia.setIdUzivatel(this.id);
            operacia.setSuma(suma);
            operacia.setDatum(vysl);
            operacia.setTyp(1);
            operacia.insert();
            System.out.print("Vas kredit bol navyseny o " + suma + "\u20ac");
        }
        catch (IOException ex) {
            System.out.print("Zla suma");
        }
    }

    private void vyberKreditu() throws SQLException, IOException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte cislo uctu: ");
        String ucet = br.readLine();
        System.out.print("Zadajte kolko chcete vybrat: ");
        try {
            int suma = Integer.parseInt(br.readLine());
            if (NajdiUzivatela.getInstance().findById(this.id).getKredit() - suma < 0) {
                System.out.println("Lutujeme ale nemate dost financii na tuto operaciu ");
            } else {
                Uzivatelia uzivatel = new Uzivatelia();
                uzivatel.setId(this.id);
                uzivatel.setMeno(NajdiUzivatela.getInstance().findById(this.id).getMeno());
                uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(this.id).getPriezvisko());
                uzivatel.setEmail(NajdiUzivatela.getInstance().findById(this.id).getEmail());
                uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(this.id).getNarodenie());
                uzivatel.setKredit(NajdiUzivatela.getInstance().findById(this.id).getKredit() - suma);
                uzivatel.update();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                String datum = sdf.format(timestamp);
                Date date = sdf.parse(datum);
                Timestamp vysl = new Timestamp(date.getTime());
                Operacie operacia = new Operacie();
                operacia.setIdUzivatel(this.id);
                operacia.setSuma(suma);
                operacia.setDatum(vysl);
                operacia.setTyp(0);
                operacia.insert();
                System.out.print("Z Vasho kreditu bolo prevedenych " + suma + "\u20ac na ucet " + ucet);
            }
        }
        catch (IOException ex) {
            System.out.print("Zla suma");
        }
    }

    private void odstranitKonto() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Urcite si prajete odstranit konto? (Y/N)");
        String s = br.readLine();
        if (s.equals("Y")) {
            Uzivatelia uzivatel = NajdiUzivatela.getInstance().findById(this.id);
            uzivatel.setId(this.id);
            uzivatel.delete();
            System.out.println("Ucet bol odstraneny");
            this.exit();
        } else {
            System.out.println("Ucet sa nepodarilo odstranit");
        }
    }

    private void zobrazitTikety() {
        try {
            for (Tiket tiket : NajdiTiket.getInstance().findPodany(this.id)) {
                if (tiket == null) {
                    System.out.println("taky tiket nie je");
                    continue;
                }
                TiketPrinter.getInstance().print(tiket);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

