/*
 * Decompiled with CFR 0.152.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.Bookmakers;
import rdg.Kancelaria;
import rdg.NajdiBookmaker;
import rdg.NajdiKancelaria;
import rdg.NajdiPocetGolov;
import rdg.NajdiUdalost;
import rdg.NajdiUmiestnenie;
import rdg.NajdiUzivatela;
import rdg.NajdiZapas;
import rdg.PocetGolovKurzy;
import rdg.Udalosti;
import rdg.UmiestnenieKurzy;
import rdg.Uzivatelia;
import rdg.ZapasKurzy;
import user.KurzyPocetGolovPrinter;
import user.KurzyUmiestneniePrinter;
import user.KurzyZapasPrinter;
import user.Menu;
import user.PonukaPrinter;

public class MenuKancelaria
extends Menu {
    private final Integer id;

    MenuKancelaria(Integer id) {
        this.id = id;
    }

    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. stav konta                 *");
        System.out.println("* 2. vklad konta                *");
        System.out.println("* 3. aktualizuj a vyhodnot      *");
        System.out.println("* 4. 3 najlepsi tiperi          *");
        System.out.println("* 5. 3 najstavko. udalosti      *");
        System.out.println("* 6. 3 najlepsi bookmakeri      *");
        System.out.println("* 7. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1": {
                    this.stavKonta();
                    break;
                }
                case "2": {
                    this.vkladKreditu();
                    break;
                }
                case "3": {
                    this.aktualizuj();
                    this.vyhodnot();
                    break;
                }
                case "4": {
                    this.najlepsiTiper();
                    break;
                }
                case "5": {
                    this.najstavkovanejsiaUdalost();
                    break;
                }
                case "6": {
                    this.najlepsiBookmaker();
                    break;
                }
                case "7": {
                    this.exit();
                    break;
                }
                default: {
                    System.out.println("Unknown option");
                    break;
                }
            }
        }
        catch (SQLException | ParseException ex) {
            Logger.getLogger(MenuKancelaria.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void vyhodnot() {
    }

    private void aktualizuj() {
        Random rnd = new Random();
        for (ZapasKurzy zapas : NajdiZapas.getInstance().findNeAktualne()) {
            try {
                ZapasKurzy z = new ZapasKurzy();
                z.setId(zapas.getId());
                z.setSpravne(rnd.nextInt(3));
                z.update();
                System.out.println(z.getId() + " " + rnd.nextInt(2));
            }
            catch (SQLException ex) {
                System.out.println("Ziadne zapasy");
            }
        }
        for (UmiestnenieKurzy umiestnenie : NajdiUmiestnenie.getInstance().findNeAktualne()) {
            try {
                UmiestnenieKurzy u = new UmiestnenieKurzy();
                u.setId(umiestnenie.getId());
                u.setSpravne(rnd.nextInt(2) + 1);
                u.update();
            }
            catch (SQLException ex) {
                System.out.println("Ziadne umiestnenia");
            }
        }
        for (PocetGolovKurzy pocetgolov : NajdiPocetGolov.getInstance().findNeAktualne()) {
            try {
                PocetGolovKurzy p = new PocetGolovKurzy();
                p.setId(pocetgolov.getId());
                p.setSpravne(rnd.nextInt(3) + 1);
                p.update();
            }
            catch (SQLException ex) {
                System.out.println("Ziadne pocty golov");
            }
        }
        System.out.println("Udalosti boli uspesne vyhodnotene");
    }

    private void stavKonta() throws SQLException {
        System.out.println("Stav vasho konta je: " + NajdiKancelaria.getInstance().findById(this.id).getKredit() + "\u20ac");
    }

    private void vkladKreditu() throws SQLException, ParseException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Zadajte kolko chcete dobit na konto: ");
        try {
            int suma = Integer.parseInt(br.readLine());
            Kancelaria uzivatel = new Kancelaria();
            uzivatel.setId(this.id);
            uzivatel.setKredit(NajdiKancelaria.getInstance().findById(this.id).getKredit() + suma);
            uzivatel.update();
            System.out.print("Vas kredit bol navyseny o " + suma + "\u20ac");
        }
        catch (IOException ex) {
            System.out.print("Zla suma");
        }
    }

    private void najstavkovanejsiaUdalost() {
        try {
            for (Udalosti udalost : NajdiUdalost.getInstance().findNaj()) {
                PonukaPrinter.getInstance().print(udalost);
                if (NajdiZapas.getInstance().findByIdBool(udalost.getId())) {
                    KurzyZapasPrinter.getInstance().print(udalost.getId());
                }
                if (NajdiUmiestnenie.getInstance().findByIdBool(udalost.getId())) {
                    KurzyUmiestneniePrinter.getInstance().print(udalost.getId());
                }
                if (!NajdiPocetGolov.getInstance().findByIdBool(udalost.getId())) continue;
                KurzyPocetGolovPrinter.getInstance().print(udalost.getId());
            }
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }

    private void najlepsiTiper() throws SQLException {
        System.out.println("Najlepsi tiperi");
        for (Uzivatelia naj : NajdiUzivatela.getInstance().findNaj()) {
            System.out.println("ID: " + naj.getId());
            System.out.println("Meno: " + naj.getMeno());
            System.out.println("Priezvisko: " + naj.getPriezvisko());
            System.out.println("Body: " + naj.getBod());
            System.out.println();
        }
    }

    private void najlepsiBookmaker() throws SQLException {
        System.out.println("Najlepsi bookmakeri");
        for (Bookmakers naj : NajdiBookmaker.getInstance().findNaj()) {
            System.out.println("ID: " + naj.getId());
            System.out.println("Meno: " + naj.getMeno());
            System.out.println("Priezvisko: " + naj.getPriezvisko());
            System.out.println("Zetony: " + naj.getZetony());
            System.out.println();
        }
    }
}

