/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiOperacie extends BaseFinder<Operacie>{
    private static final NajdiOperacie INSTANCE = new NajdiOperacie();
    
    public static NajdiOperacie getInstance() { return INSTANCE; }
    
    private NajdiOperacie() { }
		
    public Operacie findById(int id) throws SQLException {
        return findByInt("SELECT * FROM operacie WHERE id = ?", id);
    }
    
    public Operacie findByIdUzivatel(int id) throws SQLException {
        return findByInt("SELECT * FROM operacie WHERE id_uzivatel = ?", id);
    }
    public List<Operacie> findAllByInt(Integer id) throws SQLException {
        try {
            return findAllByInt("SELECT * FROM operacie WHERE AND id_uzivatel = ?", id);
        } catch (SQLException ex) {
           System.out.println("Nenasla sa ziadna operacia");
        }
        return null;
    }
    
    public boolean findByIntBool(Integer id) {
        try {
            if(findByInt("SELECT * FROM kancelaria WHERE id_uzivatel = ?", id).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }
    
    public List<Operacie> findAllByIntVklad(Integer id) throws SQLException {
        try {
            return findAllByInt("SELECT * FROM operacie WHERE typ='1' AND id_uzivatel = ? LIMIT 5", id);
        } catch (SQLException ex) {
           System.out.println("Nenasla sa ziadna operacia");
        }
        return null;
    }
    public List<Operacie> findAllByIntVyber(Integer id) {
        try {
            return findAllByInt("SELECT * FROM operacie WHERE typ='0' AND id_uzivatel = ? LIMIT 5", id);
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna operacia");
        }
        return null;
    }

    public List<Operacie> findAll() throws SQLException {
        return findAll("SELECT * FROM operacie");
    }
   
    @Override
    protected Operacie load(ResultSet r) throws SQLException {
        Operacie c = new Operacie();
        
        c.setId(r.getInt("id"));
        c.setIdUzivatel(r.getInt("id_uzivatel")); 
        c.setSuma(r.getDouble("suma")); 
        c.setDatum(r.getTimestamp("datum")); 
        c.setTyp(r.getInt("typ")); 
        
        return c;
    }
}
