/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiUdalost extends BaseFinder<Udalosti>{
    private static final NajdiUdalost INSTANCE = new NajdiUdalost();
    
    public static NajdiUdalost getInstance() { return INSTANCE; }
    
    private NajdiUdalost() { }
		
    public Udalosti findById(int id) throws SQLException {
        return findByInt("SELECT * FROM udalost WHERE id = ?", id);
    }
    public Udalosti findByIdAkt(int id) throws SQLException {
        return findByInt("SELECT * FROM udalost WHERE id = ? AND koniec_stavkovania>=NOW()", id);
    }
    
    public Udalosti findByIdUdalosti(int id) throws SQLException {
        return findByInt("SELECT * FROM udalost WHERE id_udalost = ?", id);
    }
    
    public List<Udalosti> findNaj() {
        try {
            return findAll("SELECT * FROM udalost WHERE koniec_stavkovania>=NOW() ORDER BY pocetpodani DESC LIMIT 3");
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
        return null;
    }
    
    public List<Udalosti> findAktualne() {
        try {
            return findAll("SELECT * FROM udalost WHERE koniec_stavkovania>=NOW()");
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
        return null;
    }
   
 

    public List<Udalosti> findAll() throws SQLException {
        return findAll("SELECT * FROM udalost ");
    }
   
    @Override
    protected Udalosti load(ResultSet r) throws SQLException {
        Udalosti c = new Udalosti();
        
        c.setId(r.getInt("id"));
        c.setIdBookmaker(r.getInt("id_bookmaker"));
        c.setDatumKonania(r.getTimestamp("datum_konania"));
        c.setKoniecStavkovania(r.getTimestamp("koniec_stavkovania"));
        c.setPocetPodani(r.getInt("pocetpodani"));
        
        return c;
    }


}
