/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiUzivatela extends BaseFinder<Uzivatelia> {
    
    private static final NajdiUzivatela INSTANCE = new NajdiUzivatela();
    
    public static NajdiUzivatela getInstance() { return INSTANCE; }
    
    private NajdiUzivatela() { }
		
    public Uzivatelia findById(int id) throws SQLException {
        return findByInt("SELECT * FROM uzivatelia WHERE id = ?", id);
    }
    
    public Uzivatelia findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM uzivatelia WHERE login = ?", login);
    }
    
     public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM uzivatelia WHERE login = ?", login).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }

    public List<Uzivatelia> findAll() throws SQLException {
        return findAll("SELECT * FROM uzivatelia");
    }
    
    public List<Uzivatelia> findNaj() throws SQLException {
        return  findAll("SELECT * FROM uzivatelia ORDER BY bod DESC LIMIT 3");
    }

    @Override
    protected Uzivatelia load(ResultSet r) throws SQLException {
        Uzivatelia c = new Uzivatelia();

        c.setId(r.getInt("id"));
        c.setMeno(r.getString("meno"));
        c.setLogin(r.getString("login"));
        c.setHeslo(r.getString("heslo"));
        c.setPriezvisko(r.getString("priezvisko"));
        c.setEmail(r.getString("email"));
        c.setNarodenie(r.getTimestamp("narodenie"));
        c.setBod(r.getInt("bod"));
        c.setKredit(r.getInt("kredit"));
        c.setCisloTiketu(r.getInt("cislo_tiketu"));

        return c;
    }

}
