/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

/**
 *
 * @author mzrub
 */
public class Uzivatelia extends BaseGateway {
	
    private Integer id;
    private String meno;
    private String priezvisko;
    private String login;
    private String heslo;
    private String email;
    private Timestamp narodenie;
    private Integer kredit;
    private Integer bod;
    private boolean a;
    private Integer cislo_tiketu;

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }	
    
    public String getMeno() { return meno; }
    public void setMeno(String meno) { this.meno = meno; }

    public String getPriezvisko() { return priezvisko; }
    public void setPriezvisko(String priezvisko) { this.priezvisko = priezvisko; }

    public String getLogin() { return login; }
    public void setLogin(String login) { this.login = login; }
    
    public String getHeslo() { return heslo; }
    public void setHeslo(String heslo) { this.heslo = heslo; }
    
    public String getEmail() { return email; }
    public void setEmail(String email) { this.email = email; }

    public Timestamp getNarodenie() { return narodenie; }
    public void setNarodenie(Timestamp narodenie) { this.narodenie = narodenie; }

    public Integer getKredit() { return kredit; }
    public void setKredit(Integer kredit) { this.kredit = kredit; }
    
    public Integer getBod() { return bod; }
    public void setBod(Integer bod) { this.bod = bod; }
    
    public Integer getCisloTiketu() { return cislo_tiketu; }
    public void setCisloTiketu(Integer cislo_tiketu) { this.cislo_tiketu=cislo_tiketu; }
    
    public boolean getBookmaker() { return false; }
    public void setBookmaker(boolean a) { this.a=a;}
    public boolean getKancelaria() { return false; }
    public void setKancelaria(boolean a) { this.a=a; }
    public boolean getUzivatel() { return true; }
    public void setUzivatel(boolean a) { this.a=a; }
    
    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO uzivatelia (meno, priezvisko, email, narodenie, bod ,login, heslo, kredit, cislo_tiketu) VALUES (?,?,?,?,?,?,?,?,?)");
    }
    


    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, meno);
        s.setString(2, priezvisko);
        s.setString(3, email);
        s.setTimestamp(4, narodenie);
        s.setInt(5, bod);
        s.setString(6, login);
        s.setString(7, heslo);
        s.setInt(8, kredit);
        s.setInt(9, cislo_tiketu);
 
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE uzivatelia SET meno = ?, priezvisko = ?, email = ?, narodenie = ?,kredit=?, cislo_tiketu=?, bod=? WHERE id = ?");
    }
    
    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setString(1, meno);
        s.setString(2, priezvisko);
        s.setString(3, email);
        s.setTimestamp(4, narodenie);
        s.setDouble(5,kredit);
        s.setInt(6, cislo_tiketu);
        s.setInt(7, bod);
        s.setInt(8, id);
        
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        delete("ON DELETE FROM uzivatelia WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
}
	

