/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ts;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import prihlasovanie.DbContext;
import rdg.Kancelaria;
import rdg.NajdiKancelaria;
import rdg.NajdiUzivatela;
import rdg.Operacie;
import rdg.Uzivatelia;

/**
 *
 * @author mzrub
 */
public class UrobOperaciu {
    private static final UrobOperaciu INSTANCE = new UrobOperaciu();
    
    public static UrobOperaciu getInstance() {
        return INSTANCE;
    }
    
    public boolean urobVklad(Integer id, Integer suma) throws TiketException, SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
                     
            Uzivatelia uzivatel=new Uzivatelia();
            uzivatel.setId(id);
            uzivatel.setMeno(NajdiUzivatela.getInstance().findById(id).getMeno());
            uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(id).getPriezvisko());
            uzivatel.setEmail(NajdiUzivatela.getInstance().findById(id).getEmail());
            uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(id).getNarodenie());
            uzivatel.setKredit(NajdiUzivatela.getInstance().findById(id).getKredit()+suma);
            uzivatel.setCisloTiketu(NajdiUzivatela.getInstance().findById(id).getCisloTiketu());
            uzivatel.setBod(NajdiUzivatela.getInstance().findById(id).getBod());
            uzivatel.update();
                
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");                	
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String datum=sdf.format(timestamp);                
            Date date = sdf.parse(datum);	                    
            Timestamp vysl = new Timestamp(date.getTime());
            
            Operacie operacia = new Operacie();
            operacia.setIdUzivatel(id);
            operacia.setSuma(suma);
            operacia.setDatum(vysl);
            operacia.setTyp(1);
            operacia.insert();
            
            DbContext.getConnection().commit();            
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
        DbContext.getConnection().setAutoCommit(true);
        }
    }
    public boolean urobVkladKanc(Integer suma) throws TiketException, SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
                     
            Kancelaria uzivatel=new Kancelaria();
            uzivatel.setId(1);
            uzivatel.setKredit(NajdiKancelaria.getInstance().findById(1).getKredit()+suma);
            uzivatel.update();
            
            DbContext.getConnection().commit();            
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
        DbContext.getConnection().setAutoCommit(true);
        }
    }
    
    public boolean urobVyber(Integer id, Integer suma) throws TiketException, SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Uzivatelia uzivatel=new Uzivatelia();
                uzivatel.setId(id);
                uzivatel.setMeno(NajdiUzivatela.getInstance().findById(id).getMeno());
                uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(id).getPriezvisko());
                uzivatel.setEmail(NajdiUzivatela.getInstance().findById(id).getEmail());
                uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(id).getNarodenie());
                uzivatel.setKredit(NajdiUzivatela.getInstance().findById(id).getKredit()-suma);
                uzivatel.setCisloTiketu(NajdiUzivatela.getInstance().findById(id).getCisloTiketu());
                uzivatel.setBod(NajdiUzivatela.getInstance().findById(id).getBod());
                uzivatel.update();
                
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");                	
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                String datum=sdf.format(timestamp);                
                Date date = sdf.parse(datum);	                    
                java.sql.Timestamp vysl = new java.sql.Timestamp(date.getTime());
                
                Operacie operacia = new Operacie();
                operacia.setIdUzivatel(id);
                operacia.setSuma(suma);
                operacia.setDatum(vysl);
                operacia.setTyp(0);
                operacia.insert();
            
            DbContext.getConnection().commit();            
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
        DbContext.getConnection().setAutoCommit(true);
        }
    }
    
    public boolean platbaKanc(Integer id, Integer money) throws TiketException, SQLException, ParseException {

        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Kancelaria k=new Kancelaria();
            k.setId(1);
            k.setKredit(NajdiKancelaria.getInstance().findById(1).getKredit()-money);
            k.update();

            Uzivatelia uzivatel=new Uzivatelia();
            uzivatel.setId(id);
            uzivatel.setMeno(NajdiUzivatela.getInstance().findById(id).getMeno());
            uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(id).getPriezvisko());
            uzivatel.setEmail(NajdiUzivatela.getInstance().findById(id).getEmail());
            uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(id).getNarodenie());
            uzivatel.setKredit(NajdiUzivatela.getInstance().findById(id).getKredit()+money);
            uzivatel.setBod(NajdiUzivatela.getInstance().findById(id).getBod()+money);
            uzivatel.setCisloTiketu(NajdiUzivatela.getInstance().findById(id).getCisloTiketu());
            uzivatel.setBod(NajdiUzivatela.getInstance().findById(id).getBod());
            uzivatel.update();
            
            DbContext.getConnection().commit();            
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
        DbContext.getConnection().setAutoCommit(true);
        }
    }
    
}

