/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.NajdiUzivatela;
import rdg.Uzivatelia;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import rdg.Bookmakers;
import rdg.Kancelaria;
import rdg.NajdiBookmaker;
import rdg.NajdiKancelaria;
import rdg.NajdiTiket;
import rdg.Tiket;
import ts.TiketException;
import ts.UrobOperaciu;


/**
 *
 * @author mzrub
 */
public class prihlasovanie extends Menu{
        
    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. prihlasenie                *"); //
        System.out.println("* 2. registracia                *");//
        System.out.println("*********************************");
    } 
    
    @Override
    public void handle(String option) {
        try {
            switch (option) {
            case "1":   prihlas(); break;
            case "2":   registruj(); break;
            case "3":   exit(); break;
            default:    System.out.println("Unknown option"); break;
        } 
        }
        catch (IOException | SQLException | ParseException ex) {
                Logger.getLogger(prihlasovanie.class.getName()).log(Level.SEVERE, null, ex);
            }

    }
    private void vyhodnotitTikety(Integer id) {
        try {
            for(int cislo=1;cislo<=NajdiUzivatela.getInstance().findById(id).getCisloTiketu();cislo++){
                boolean vyherny=true;
                boolean hotovo=true;
                double suma=0;
                double kurz=1;
                for (Tiket tiket : NajdiTiket.getInstance().findVypis(id, cislo)){    
                    if(tiket.getStav()==2) vyherny=false;
                    if(tiket.getStav()==0) hotovo=false;
                    suma=tiket.getSuma();
                    kurz*=tiket.getKurz();
                }
                if(vyherny && hotovo){
                    Integer money=(int)Math.round(suma*kurz);
                    UrobOperaciu.getInstance().platbaKanc(id, money);                    
                }
            }
        } catch (SQLException | TiketException ex) {
            Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("taky tiket nie je");
        }catch (ParseException ex) {
            Logger.getLogger(prihlasovanie.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
     private void prihlas()  { 
        try {
            System.out.println("******************");
            System.out.println("*  prihlasenie   *");
            System.out.println("******************");          
            
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("zadaj login: ");
            String log = br.readLine();
            
            
            Uzivatelia z = NajdiUzivatela.getInstance().findByLogin(log);
            Bookmakers b = NajdiBookmaker.getInstance().findByLogin(log);
            Kancelaria k = NajdiKancelaria.getInstance().findByLogin(log);
            if (z == null && b==null && k==null){
                System.out.println("Zakaznik s takymto loginom neexistuje");
            }
            
            else{
                System.out.print("zadaj heslo: ");
                String heslo = br.readLine();
                if(NajdiUzivatela.getInstance().findByLoginBool(log) && !z.getHeslo().equals(heslo)){                     
                        System.out.println("nespravne heslo");
                }
                else if(NajdiBookmaker.getInstance().findByLoginBool(log) && !b.getHeslo().equals(heslo)){
                     System.out.println("nespravne heslo");                
                }
                else if(NajdiKancelaria.getInstance().findByLoginBool(log) && !k.getHeslo().equals(heslo)){
                
                     System.out.println("nespravne heslo");                
                }
                else{
                    if(NajdiBookmaker.getInstance().findByLoginBool(log) && b.getBookmaker() == true){
                        System.out.print("Vitajte " + b.getMeno());
                        MenuBookmaker bookmaker = new MenuBookmaker(b.getId());
                        bookmaker.run();
                    }
                    else if(NajdiKancelaria.getInstance().findByLoginBool(log) && k.getKancelaria() == true){
                        System.out.print("Kancelaria");
                        MenuKancelaria kancelaria = new MenuKancelaria(k.getId());
                        kancelaria.run();
                    }
                    
                    else if (NajdiUzivatela.getInstance().findByLoginBool(log) && z.getUzivatel() == true){
                        System.out.print("Vitajte "+z.getMeno());
                        MainMenu menu = new MainMenu(z.getId());
                        vyhodnotitTikety(z.getId());
                        menu.run();
                    }
                }
            }
        } catch (SQLException | IOException ex ) {
            System.out.println("Uzivatel s tymto menom neexistuje");
            System.out.println("Registracia");
        }       
     }

     
     private void registruj() throws IOException, SQLException, ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in)); 
        Uzivatelia c = new Uzivatelia();
        
        System.out.print("zadaj login: ");
        String log = br.readLine();
        Uzivatelia z = NajdiUzivatela.getInstance().findByLogin(log);
	if (z != null){
	    System.out.print("Uzivatel s takymto loginom uz existuje");
 
	}
        else{
            System.out.print("zadaj login este raz: ");
            c.setLogin(br.readLine());
            System.out.print("zadaj heslo: ");
            c.setHeslo(br.readLine());
            System.out.print("zadaj meno: ");
            c.setMeno(br.readLine());
            System.out.print("zadaj priezvisko: ");
            c.setPriezvisko(br.readLine());
            System.out.print("zadaj email: ");
            c.setEmail(br.readLine());
            
            System.out.print("zadaj datum nar. (2018-04-24): "); 
            String str= br.readLine(); 
            String pattern = "yyyy-MM-dd";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            Date date = simpleDateFormat.parse(str);	
            java.sql.Timestamp narodenie = new java.sql.Timestamp(date.getTime());
            c.setNarodenie(narodenie); 
            c.setKredit(0);
            c.setBod(0);
            c.setCisloTiketu(1);
            c.insert();
            c.setUzivatel(true);
        System.out.println("Novy uzivatel bol vytvoreny");
        System.out.print("Vase ID je: ");
        System.out.println(c.getId());
        prihlas();
        }
     }
}
