/*-- Database: projekt_stavkovakancelaria

-- DROP DATABASE "projekt_stavkovakancelaria";

CREATE DATABASE "projekt_stavkovakancelaria"
    WITH 
    OWNER = postgres
    ENCODING = 'UTF8'
    LC_COLLATE = 'Slovak_Slovakia.1250'
    LC_CTYPE = 'Slovak_Slovakia.1250'
    TABLESPACE = pg_default
    CONNECTION LIMIT = -1;
  */  
  
-- pomocne tabulky
drop table if exists mena cascade;
create table mena
(
	first_name varchar
);

drop table if exists priezviska cascade;
create table priezviska
(
	last_name varchar
);

drop table if exists timy cascade;
create table timy
(
	nazov varchar
);

--hlavne tabulky
drop table if exists kancelaria cascade;
create table kancelaria(
	id serial primary key,
	kredit numeric,
	login varchar,
	heslo varchar
);

drop table if exists bookmaker cascade;
create table bookmaker(
	id serial primary key,
	meno varchar,
	priezvisko varchar,
	zetony numeric,
	login varchar,
	heslo varchar
);

drop table if exists uzivatelia cascade;
create table uzivatelia(
	id serial primary key,
	meno varchar,
	priezvisko varchar,
	email varchar,
	narodenie date,
	bod numeric,
	login varchar,
	heslo varchar,
	kredit numeric,
	cislo_tiketu numeric
);

drop table if exists operacie cascade;
create table operacie(
	id serial primary key,
	datum timestamp,
	id_uzivatel integer references uzivatelia(id),
	suma numeric,
	typ numeric
);


drop table if exists udalost cascade;
create table udalost(
	id serial primary key,
	id_bookmaker integer references bookmaker(id),
	datum_konania timestamp,
	koniec_stavkovania timestamp,
	pocetpodani numeric
);

drop table if exists zapas cascade;
create table zapas(
	id serial primary key,
	id_udalost integer references udalost(id),
	domaci varchar,
	hostia varchar,
	dom numeric,
	rem numeric,
	hos numeric,
	spravne numeric
);

drop table if exists pocetgolov cascade;
create table pocetgolov(
	id serial primary key,
	id_udalost integer references udalost(id),
	domaci varchar,
	hostia varchar,
	najviacjeden numeric,
	dvatri numeric,
	styripat numeric,
	viacakopat numeric,
	spravne numeric
);

drop table if exists umiestnenie cascade;
create table umiestnenie(
	id serial primary key,
	id_udalost integer references udalost(id),
	sutaziaci varchar,
	prvy numeric,
	dotri numeric,
	dopat numeric,
	spravne numeric
);

drop table if exists tiket cascade;
create table tiket(
	id serial primary key,
	id_uzivatel integer references uzivatelia(id),
	suma numeric,
	stav numeric,
	podany numeric,
	id_udalost integer references udalost(id),
	tip numeric,
	cislo_tiketu numeric
	
);
