/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiBookmaker extends BaseFinder<Bookmakers> {
    
    private static final NajdiBookmaker INSTANCE = new NajdiBookmaker();
    
    public static NajdiBookmaker getInstance() { return INSTANCE; }
    
    private NajdiBookmaker() { }
		
    public Bookmakers findById(int id) throws SQLException {
        return findByInt("SELECT * FROM bookmaker WHERE id = ?", id);
    }
    
    public List<Bookmakers> findNaj() throws SQLException {
        return findAll("SELECT * FROM bookmaker ORDER BY zetony DESC LIMIT 3");
    }
    
    public Bookmakers findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM bookmaker WHERE login = ?", login);
    }
    public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM bookmaker WHERE login = ?", login).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }

    public List<Bookmakers> findAll() throws SQLException {
        return findAll("SELECT * FROM bookmaker");
    }

    @Override
    protected Bookmakers load(ResultSet r) throws SQLException {
        Bookmakers c = new Bookmakers();

        c.setId(r.getInt("id"));
        c.setMeno(r.getString("meno"));
        c.setLogin(r.getString("login"));
        c.setHeslo(r.getString("heslo"));
        c.setPriezvisko(r.getString("priezvisko"));
        
        c.setZetony(r.getInt("zetony"));

        return c;
    }

}
