/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiKancelaria  extends BaseFinder<Kancelaria> {
    
    private static final NajdiKancelaria INSTANCE = new NajdiKancelaria();
    
    public static NajdiKancelaria getInstance() { return INSTANCE; }
    
    private NajdiKancelaria() { }
		
    public Kancelaria findById(int id) throws SQLException {
        return findByInt("SELECT * FROM kancelaria WHERE id = ?", id);
    }
    
    public Kancelaria findByLogin(String login) throws SQLException {
        return findByString("SELECT * FROM kancelaria WHERE login = ?", login);
    }
    
    public boolean findByLoginBool(String login) {
        try {
            if(findByString("SELECT * FROM kancelaria WHERE login = ?", login).equals(null)) return false; 
            return true;
        } catch (SQLException | NullPointerException ex ) {
            return false;
        }     
    }

    public List<Kancelaria> findAll() throws SQLException {
        return findAll("SELECT * FROM kancelaria");
    }

    @Override
    protected Kancelaria load(ResultSet r) throws SQLException {
        Kancelaria c = new Kancelaria();

        c.setId(r.getInt("id"));
        c.setLogin(r.getString("login"));
        c.setHeslo(r.getString("heslo"));   
        
        c.setKredit(r.getInt("kredit"));

        return c;
    }
}