/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiTiket extends BaseFinder<Tiket> {
    
    private static final NajdiTiket INSTANCE = new NajdiTiket();
    
    public static NajdiTiket getInstance() { return INSTANCE; }
    
    private NajdiTiket() { }
    
    public Tiket findById(int id) throws SQLException {
        return findByInt("SELECT * FROM tiket WHERE id = ? and podany='0'", id);
    }
    
    public boolean findUdalost(int id_udalost, int id_uzivatel) throws SQLException {
        if(findByInts("SELECT * FROM tiket WHERE id_udalost = ? and id_uzivatel=? and podany='0'", id_udalost, id_uzivatel) == null){
            return false;
        }
        return true;
    }
    
    public List<Tiket> findAllByInt(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tiket WHERE id_uzivatel = ?", id);
    }
    public List<Tiket> findNepodany(Integer id) throws SQLException {
        return findAllByInt("SELECT * FROM tiket WHERE podany='0' and id_uzivatel = ?", id);
    }
    public List<Tiket> findPodany(Integer id, Integer cislo) throws SQLException {
        return findAllByInt("SELECT * FROM tiket WHERE podany='1' and id_uzivatel = ?", id);
    }
    
    public List<Tiket> findVypis(Integer id, Integer cislo) throws SQLException {
        return findAllByInts("SELECT * FROM tiket WHERE podany='1' and id_uzivatel = ? and cislo_tiketu=?", id, cislo);
    }

    public List<Tiket> findAll() throws SQLException {
        return findAll("SELECT * FROM tiket");
    }

    @Override
    protected Tiket load(ResultSet r) throws SQLException {
        Tiket k = new Tiket();

        k.setId(r.getInt("id"));
        k.setIdUzivatel(r.getInt("id_uzivatel"));
        k.setSuma(r.getInt("suma"));
        k.setStav(r.getInt("stav"));
        k.setPodany(r.getInt("podany"));
        k.setIdUdalost(r.getInt("id_udalost"));
        k.setTip(r.getInt("tip"));
        return k;
    }

}