/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author mzrub
 */
public class NajdiUmiestnenie extends BaseFinder<UmiestnenieKurzy>{
    private static final NajdiUmiestnenie INSTANCE = new NajdiUmiestnenie();
    
    public static NajdiUmiestnenie getInstance() { return INSTANCE; }
    
    private NajdiUmiestnenie() { }
	
    public List<UmiestnenieKurzy> findNeAktualne() {
        try {
            return findAll("SELECT * FROM umiestnenie INNER JOIN udalost ON umiestnenie.id_udalost=udalost.id  WHERE udalost.datum_konania<NOW() AND umiestnenie.spravne IS NULL");
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
        return null;
    }
        
    public UmiestnenieKurzy findById(int id) throws SQLException {
        return findByInt("SELECT * FROM umiestnenie WHERE id = ?", id);
    }
    
    public UmiestnenieKurzy findByIdUdalosti(int id) throws SQLException {
        return findByInt("SELECT * FROM umiestnenie WHERE id_udalost = ?", id);
    }
    
     public boolean findByIdBool(int id) {
        try {
           if(findByInt("SELECT * FROM umiestnenie WHERE id_udalost = ?", id).equals(null)) return false;
            return true;
        } catch (SQLException ex) {
            return false;
        }     
         catch (NullPointerException ex ) {
            return false;
        }
    }

    public List<UmiestnenieKurzy> findAll() throws SQLException {
        return findAll("SELECT * FROM umiestnenie");
    }
   
    @Override
    protected UmiestnenieKurzy load(ResultSet r) throws SQLException {
        UmiestnenieKurzy c = new UmiestnenieKurzy();;
        
        c.setId(r.getInt("id"));
        c.setIdUdalost(r.getInt("id_udalost"));
        c.setSutaziaci(r.getString("sutaziaci"));
        c.setPrvy(r.getDouble("prvy"));
        c.setDoTri(r.getDouble("dotri"));
        c.setDoPat(r.getDouble("dopat"));
        c.setSpravne(r.getInt("spravne"));
        return c;
    }
}
