/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author mzrub
 */
public class Tiket extends BaseGateway {
	
    private Integer id;
    private Integer id_uzivatel;
    private Integer suma;
    private Integer stav;
    private Integer podany;
    private Integer id_udalost;
    private Integer tip;
    private Integer cislo_tiketu;
    private double kurz;
    
    
    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }
    
    public Integer getIdUdalost() { return id_udalost;	}
    public void setIdUdalost(Integer id_udalost) { this.id_udalost = id_udalost; }

    public Integer getIdUzivatel() { return id_uzivatel; }
    public void setIdUzivatel(Integer id_uzivatel) { this.id_uzivatel = id_uzivatel; }
    
    public Integer getSuma() { return suma; }
    public void setSuma(Integer suma) { this.suma = suma; }    
    
    public Integer getStav() { return stav; }
    public void setStav(Integer stav) { this.stav = stav; }
    
    public Integer getPodany() { return podany; }
    public void setPodany(Integer podany) { this.podany = podany; }
    
    public Integer getTip() { return tip; }
    public void setTip(Integer tip) { this.tip = tip; }    
        
    public Integer getCisloTiketu() { return cislo_tiketu; }
    public void setCisloTiketu(Integer cislo_tiketu) { this.cislo_tiketu = cislo_tiketu; }
    
    public double getKurz() throws SQLException { 
        if(NajdiZapas.getInstance().findByIdBool(id_udalost)){
            if (tip==1) {
                return NajdiZapas.getInstance().findByIdUdalosti(id_udalost).getDom();
            }
            else if (tip==0) {
                return NajdiZapas.getInstance().findByIdUdalosti(id_udalost).getRem();
            }
            else if (tip==2) {
                return NajdiZapas.getInstance().findByIdUdalosti(id_udalost).getHos();
            }
        }                              
        if(NajdiUmiestnenie.getInstance().findByIdBool(id_udalost)){
            if (tip==1) {
                return NajdiUmiestnenie.getInstance().findByIdUdalosti(id_udalost).getPrvy();
            }
            else if (tip==2) {
                return NajdiUmiestnenie.getInstance().findByIdUdalosti(id_udalost).getDoTri();
            }
            else if (tip==3) {
                return NajdiUmiestnenie.getInstance().findByIdUdalosti(id_udalost).getDoPat();
            }
        }               
        if(NajdiPocetGolov.getInstance().findByIdBool(id_udalost)){
            if (tip==1) {
                return NajdiPocetGolov.getInstance().findByIdUdalosti(id_udalost).getNajviacJeden();
            }
            else if (tip==2) {
                return NajdiPocetGolov.getInstance().findByIdUdalosti(id_udalost).getDvaTri();
            }
            else if (tip==3) {
                return NajdiPocetGolov.getInstance().findByIdUdalosti(id_udalost).getStyriPat();
            }
            else if (tip==4) {
                return NajdiPocetGolov.getInstance().findByIdUdalosti(id_udalost).getViacakoPat();
            }
        }        
        System.out.println("Nepodarilo sa ziskat kurz udalosti");
        return 0;
        
    }

    
    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO tiket (id_uzivatel, podany, suma, id_udalost, tip, cislo_tiketu) VALUES (?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id_uzivatel);
        s.setInt(2, suma);
        s.setInt(3, podany);
        s.setInt(4, id_udalost);
        s.setInt(5, tip);
        s.setInt(6, cislo_tiketu);
        
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE tiket SET  suma = ?, podany = ?, cislo_tiketu=? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException  {
        s.setInt(1, suma);
        s.setInt(2, podany);
        s.setInt(3, cislo_tiketu);
        s.setInt(4,id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }
        delete("DELETE FROM tiket WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }
	
}