/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

/**
 *
 * @author mzrub
 */
public class Udalosti extends BaseGateway {
    private Integer id;
    private Integer id_bookmaker;
    private Timestamp datum_konania;
    private Timestamp koniec_stavkovania;
    private Integer pocetpodani;
    
    public boolean getAktualna() {
        Timestamp aktual = new Timestamp(System.currentTimeMillis());
        if(koniec_stavkovania.compareTo(aktual)<0) return true;
        return false;
    }
    
    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }
    
    public Integer getIdBookmaker() { return id_bookmaker;	}
    public void setIdBookmaker(Integer id_bookmaker) { this.id_bookmaker = id_bookmaker; }
  
    public Timestamp getDatumKonania() { return datum_konania; }
    public void setDatumKonania(Timestamp datum_konania) { this.datum_konania = datum_konania; }
    
    public Timestamp getKoniecStavkovania() { return koniec_stavkovania; }
    public void setKoniecStavkovania(Timestamp koniec_stavkovania) { this.koniec_stavkovania = koniec_stavkovania; }

    public Integer getPocetPodani() { return pocetpodani; }
    public void setPocetPodani(Integer pocetpodani) { this.pocetpodani = pocetpodani; }


    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO udalost (datum_konania, koniec_stavkovania, pocetpodani,  id_bookmaker) VALUES (?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setTimestamp(1, datum_konania);
        s.setTimestamp(2, koniec_stavkovania);
        s.setInt(3, pocetpodani);
        s.setInt(4,id_bookmaker);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE udalost SET pocetpodani = ? WHERE id = ?");
    }


    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setInt(1, pocetpodani);
        s.setInt(2, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM udalosti WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

}
