/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ts;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import prihlasovanie.DbContext;
import rdg.NajdiUdalost;
import rdg.Tiket;
import rdg.Udalosti;

/**
 *
 * @author mzrub
 */
public class TiketPotvrd {
    private static final TiketPotvrd INSTANCE = new TiketPotvrd();
    
    public static TiketPotvrd getInstance() {
        return INSTANCE;
    }
    
    public boolean potvrd(Integer id, Integer suma, Integer cislo, Integer id_udalost) throws TiketException, SQLException, ParseException {
        if (suma == null) {
            throw new IllegalArgumentException("suma nesmie byt null");
        }
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try {
            Udalosti u=new Udalosti();
            u.setId(id_udalost);
            u.setPocetPodani(NajdiUdalost.getInstance().findByIdAkt(id_udalost).getPocetPodani()+1);
            u.update();
            
            Tiket tiket = new Tiket(); 
            tiket.setId(id);
            tiket.setSuma(suma);            
            tiket.setPodany(1);
            tiket.setCisloTiketu(cislo);
            tiket.update();
            
            DbContext.getConnection().commit();            
            return true;
        } catch(SQLException e) {
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
        DbContext.getConnection().setAutoCommit(true);
        }
    }
    
}

    

