/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import rdg.Kancelaria;
import rdg.NajdiKancelaria;
import rdg.NajdiOperacie;
import rdg.NajdiPocetGolov;
import rdg.NajdiTiket;
import rdg.NajdiUdalost;
import rdg.NajdiUmiestnenie;
import rdg.NajdiUzivatela;
import rdg.NajdiZapas;
import rdg.Operacie;
import rdg.Uzivatelia;
import rdg.Tiket;
import rdg.Udalosti;
import ts.TiketException;
import ts.TiketPotvrd;
import ts.TiketVloz;
import ts.UrobOperaciu;

/**
 *
 * @author mzrub
 */
public class MainMenu extends Menu {

    private final Integer id;

    MainMenu(Integer id) {
        this.id = id;
    }

    
    @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. vylistovat ponuku          *"); //
        System.out.println("* 2. zobrazit posledne operacie *");//
        System.out.println("* 3. pridat na tiket            *");
        System.out.println("* 4. odstranit z tiketu         *");
        System.out.println("* 5. zobrazit tiket             *");//
        System.out.println("* 6. potvrdit tiket a zaplatit  *");//
        System.out.println("* 7. zobrazit stav kreditu      *");
        System.out.println("* 8. vklad na konto             *");//
        System.out.println("* 9. vyber z konta              *");
        System.out.println("* 10. zobrazit udaje o konte    *");
        System.out.println("* 11. zobrazit tikety           *");
        System.out.println("* 12. odhlasit                  *");
        System.out.println("*********************************");
    } 
    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   listPonuka(); break;
                case "2":   zobrazOperacie(); break;              
                case "3":   pridatNaTiket(); break;                
                case "4":   odstranitZTiketu(); break;
                case "5":   zobrazitTiket(); break;
                case "6":   potvrditTiket(); break;
                case "7":   stavKonta(); break;
                case "8":   vkladKreditu(); break;
                case "9":   vyberKreditu(); break;
                case "10":   mojeUdaje(); break;
                case "11":   zobrazitTikety(); break;
                case "12":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        } catch(IOException | SQLException e) {
            throw new RuntimeException(e);
        } catch (ParseException | TiketException  ex) {
            Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
    
    private void listPonuka() {
        try {
             for (Udalosti udalost : NajdiUdalost.getInstance().findAktualne()) {                            
                PonukaPrinter.getInstance().print(udalost);
                if(NajdiZapas.getInstance().findByIdBool(udalost.getId())){                    
                    KurzyZapasPrinter.getInstance().print(udalost.getId());
                }                              
                if(NajdiUmiestnenie.getInstance().findByIdBool(udalost.getId())){
                    KurzyUmiestneniePrinter.getInstance().print(udalost.getId());
                }               
                if(NajdiPocetGolov.getInstance().findByIdBool(udalost.getId())){
                    KurzyPocetGolovPrinter.getInstance().print(udalost.getId());
                }
       
            }
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }
    private void zobrazOperacie() throws SQLException {
        try{
            System.out.println("*****Vklady*****");
            for (Operacie operacia : NajdiOperacie.getInstance().findAllByIntVklad(this.id)) {
                OperaciePrinter.getInstance().print(operacia);
            }
        } catch (NullPointerException ex)   {
            System.out.println();
        }
        try{
            System.out.println("*****Vybery*****");
             for (Operacie operacia : NajdiOperacie.getInstance().findAllByIntVyber(this.id)) {
                    OperaciePrinter.getInstance().print(operacia);
             }
        } catch (NullPointerException ex)
            {
            System.out.println();
        }
    }
    
    private void stavKonta() throws SQLException {
         System.out.println("Stav vasho konta je: " + NajdiUzivatela.getInstance().findById(id).getKredit() +"€");
     }

    private void pridatNaTiket() throws IOException, SQLException {
       BufferedReader br = new BufferedReader(new InputStreamReader(System.in));         
        System.out.print("Zadajte id udalosti: ");
        Integer id = Integer.parseInt(br.readLine());        
        System.out.print("Zadajte Vas tip: ");
        Integer tip = Integer.parseInt(br.readLine());
        boolean vysl = false;
        
        try {
            Uzivatelia ja = NajdiUzivatela.getInstance().findById(this.id);
            vysl = TiketVloz.getInstance().vloz(id, tip, ja.getId(), ja.getCisloTiketu());
        } catch (TiketException ex) {
            System.out.println(ex.getMessage());
        }    
        
        if(vysl == true){
            System.out.println("Udalost bola uspesne pridana na tiket");
        }
    }
    private void potvrditTiket() throws IOException, SQLException, ParseException, TiketException {
        System.out.print("Zadajte sumu za ktoru chcete vsadit tiket: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Integer suma = Integer.parseInt(br.readLine());          

        boolean vysl=true;
        Integer pocet=0;
        Integer remizy=0;
        double kurz=1;

        if(NajdiUzivatela.getInstance().findById(id).getKredit()-suma>=0){
            Integer cislo=NajdiUzivatela.getInstance().findById(id).getCisloTiketu();
            Uzivatelia uzivatel=new Uzivatelia();            
            uzivatel.setId(id);
            uzivatel.setMeno(NajdiUzivatela.getInstance().findById(id).getMeno());
            uzivatel.setPriezvisko(NajdiUzivatela.getInstance().findById(id).getPriezvisko());
            uzivatel.setEmail(NajdiUzivatela.getInstance().findById(id).getEmail());
            uzivatel.setNarodenie(NajdiUzivatela.getInstance().findById(id).getNarodenie());
            uzivatel.setKredit(NajdiUzivatela.getInstance().findById(id).getKredit()-suma);
            uzivatel.setCisloTiketu(NajdiUzivatela.getInstance().findById(id).getCisloTiketu()+1);
            uzivatel.setBod(NajdiUzivatela.getInstance().findById(id).getBod());
            uzivatel.update();
            
            Kancelaria k=new Kancelaria();
            k.setId(1);
            k.setKredit(NajdiKancelaria.getInstance().findById(1).getKredit()+suma);
            k.update();            

            for (Tiket tiket: NajdiTiket.getInstance().findNepodany(this.id)) {
                pocet++;
                kurz*=tiket.getKurz();  
                Integer id_tiket=tiket.getId();
                Integer id_udalost=tiket.getIdUdalost();
                TiketPotvrd.getInstance().potvrd(id_tiket, suma, cislo, id_udalost);
                if(tiket.getTip()==0) remizy++;
            }
            if (pocet==0) {
                System.out.println("Tiket je prazdny");
                vysl=false;
            }
            if (pocet!=0 && kurz==0){
                System.out.println("Nepodarilo sa ziskat kurzy");
                vysl=false;
            }
            System.out.println("Celkovy kurz je: "+kurz);  
        }
        else {
            System.out.println("Nedostatocny kredit na konte");
            vysl=false;
        }
        
        
        
        if(vysl == true){
            if(pocet==1) System.out.println("Vas solo tiket bol uspesne podany");
            if(pocet>1 && pocet!=remizy) System.out.println("Vas akumulovany tiket bol uspesne podany");
            if(pocet>3 && pocet==remizy) System.out.println("Vas tiket 'tutovka' bol uspesne podany");
            System.out.println("Vyhra je " + suma*kurz+"€");
        }
    }
    
    private void odstranitZTiketu() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        
        System.out.print("Zadajte id z tiketu: ");
        int idk = Integer.parseInt(br.readLine());

        Tiket tiket = NajdiTiket.getInstance().findById(idk);
        
        if (tiket == null) {
            System.out.println("Taka udalost v tikete neexistuje");
        } else {
            tiket.delete();
            
            System.out.println("Udalost bola uspesne odstranena z tiketu");
        }
    }
    
    private void zobrazitTiket() {
        Integer pocet=0;
        double kurz=1;
        try {
            for (Tiket tiket: NajdiTiket.getInstance().findNepodany(this.id)) {
                pocet++;
                TiketPrinter.getInstance().print(tiket);  
                kurz*=tiket.getKurz();
                
            }
            if (pocet==0) System.out.println("Tiket je prazdny");
            if (pocet!=0 && kurz==0)  System.out.println("Nepodarilo sa ziskat kurzy");
        } catch (SQLException ex) { 
                System.out.println("tiket je prazdny");
        }
        System.out.println("Celkovy kurz je: "+kurz);        
    }
    
    
    
    private void mojeUdaje() throws SQLException {
        System.out.println("Id:         " + NajdiUzivatela.getInstance().findById(id).getId());
        System.out.println("Meno:       " + NajdiUzivatela.getInstance().findById(id).getMeno());
        System.out.println("Priezvisko: " + NajdiUzivatela.getInstance().findById(id).getPriezvisko());
        System.out.println("Email:      " + NajdiUzivatela.getInstance().findById(id).getEmail());
        System.out.println("Narodenie:  " + NajdiUzivatela.getInstance().findById(id).getNarodenie());
        System.out.println("Body:       " + NajdiUzivatela.getInstance().findById(id).getBod());
    
    }
    //prerobit aby to zbehlo ako celok
    private void vkladKreditu() throws SQLException, ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));        
        System.out.print("Zadajte kolko chcete dobit na konto: ");
        try {
      
        int suma = Integer.parseInt(br.readLine());
        UrobOperaciu.getInstance().urobVklad(this.id, suma);

        System.out.print("Vas kredit bol navyseny o " + suma + "€");
        
        } catch (IOException ex ) {
            System.out.print("Zla suma");
        }
        catch (TiketException ex) {
                Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
                System.out.print("Zla suma");
            }
     }
    
    private void vyberKreditu() throws SQLException, IOException, ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));    
        System.out.print("Zadajte cislo uctu: ");
        String ucet = br.readLine();
        System.out.print("Zadajte kolko chcete vybrat: ");
        try {
            int suma = Integer.parseInt(br.readLine());
            if (NajdiUzivatela.getInstance().findById(this.id).getKredit()-suma<0){
                System.out.println("Lutujeme ale nemate dost financii na tuto operaciu ");
            }
            else{
                UrobOperaciu.getInstance().urobVyber(this.id, suma);          
                
            System.out.print("Z Vasho kreditu bolo prevedenych " + suma + "€ na ucet " + ucet);
            }
        } catch (IOException ex) {
            System.out.print("Zla suma");
        }
         catch (TiketException ex) {
                Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
                System.out.print("Zla suma");
            }
    }
        

    private void zobrazitTikety() {
        try {
            for(int cislo=1;cislo<NajdiUzivatela.getInstance().findById(id).getCisloTiketu();cislo++){
                boolean vyherny=true;
                boolean hotovo=true;
                System.out.println("Tiket cislo: "+cislo);
                for (Tiket tiket : NajdiTiket.getInstance().findVypis(this.id, cislo)){                    
                    TiketPrinter.getInstance().print(tiket);
                    if(tiket.getStav()==2) vyherny=false;
                    if(tiket.getStav()==0) hotovo=false;
                }
                if(vyherny && hotovo) System.out.println("Tiket cislo "+cislo+" je vyherny");
                if(!vyherny && hotovo) System.out.println("Tiket cislo "+cislo+" je nevyherny");
                if(!hotovo) System.out.println("Tiket cislo "+cislo+" este nieje vyhodnoteny");
                System.out.println();
                System.out.println("******************************");
            }
        } catch (SQLException ex) {
            Logger.getLogger(MainMenu.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("taky tiket nie je");
        }
    }
             
    
     
}
