/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package user;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import prihlasovanie.DbContext;
import rdg.Bookmakers;
import rdg.NajdiBookmaker;
import rdg.NajdiKancelaria;
import rdg.NajdiPocetGolov;
import rdg.NajdiUdalost;
import rdg.NajdiUmiestnenie;
import rdg.NajdiUzivatela;
import rdg.NajdiZapas;
import rdg.Udalosti;
import rdg.Uzivatelia;
import ts.TiketException;
import ts.UrobOperaciu;

/**
 *
 * @author mzrub
 */
public class MenuKancelaria extends Menu{
    private final Integer id;

    MenuKancelaria(Integer id) {
        this.id = id;
    }
   @Override
    public void print() {
        System.out.println("*********************************");
        System.out.println("* 1. stav konta                 *"); //
        System.out.println("* 2. vklad konta                *"); 
        System.out.println("* 3. aktualizuj a vyhodnot      *");
        System.out.println("* 4. 3 najlepsi tiperi          *");//
        System.out.println("* 5. 3 najstavko. udalosti      *");
        System.out.println("* 6. 3 najlepsi bookmakeri      *");
        System.out.println("* 7. zisk/strata                *");
        System.out.println("* 8. zaregistruj bookmakera     *");        
        System.out.println("* 9. exit                       *");
        System.out.println("*********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   stavKonta(); break;
                case "2":   vkladKreditu(); break;
                case "3":   aktualizuj(); break;
                case "4":   najlepsiTiper(); break;
                case "5":   najstavkovanejsiaUdalost(); break;
                case "6":   najlepsiBookmaker(); break;
                case "7":   stav(); break; 
                case "8":   registrujBookmaker(); break;
                case "9":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        
        } catch (ParseException | SQLException | IOException ex) {
            Logger.getLogger(MenuKancelaria.class.getName()).log(Level.SEVERE, null, ex);
        }

    } 
    private void registrujBookmaker() throws IOException, SQLException, ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in)); 
        Bookmakers z = new Bookmakers();
        
        System.out.print("zadaj login: ");
        String log = br.readLine();
        Bookmakers b = NajdiBookmaker.getInstance().findByLogin(log);
	if (b != null){
	    System.out.print("Bookmaker s takymto loginom uz existuje");
 
	}
        else{
            System.out.print("zadaj login este raz: ");
            z.setLogin(br.readLine());
            System.out.print("zadaj heslo: ");
            z.setHeslo(br.readLine());
            System.out.print("zadaj meno: ");
            z.setMeno(br.readLine());
            System.out.print("zadaj priezvisko: ");
            z.setPriezvisko(br.readLine());

            z.setZetony(0);
            z.insert();
            z.setBookmaker(true);
        System.out.println("Novy Bookmaker bol vytvoreny");
        System.out.print("Jeho ID je: ");
        System.out.println(z.getId());

        }
     }

    
    private void stav() throws SQLException {
        Integer stav = NajdiKancelaria.getInstance().findById(this.id).getKredit();
        if(stav>1000000){
            Integer cislo=stav-1000000;
            System.out.println("Kancelaria je v zisku " + cislo + "€");
        }
        if(stav<1000000){
            Integer cislo=1000000-stav;
            System.out.println("Kancelaria je v strate " + cislo + "€");
        }    
    }
    

    private void aktualizuj() {
        try {
            Timestamp now=new Timestamp(System.currentTimeMillis());
            String zapasy = "UPDATE zapas SET spravne = "
                    + " CASE floor(random()*3)"
                    + " WHEN 0 THEN 0 "
                    + " WHEN 1 THEN 1 "
                    + " WHEN 2 THEN 2 "
                    + "END"
                    + " WHERE spravne IS NULL AND id_udalost in (SELECT u.id FROM udalost u WHERE datum_konania < ?)";
            
            PreparedStatement z = DbContext.getConnection().prepareStatement(zapasy);
            z.setTimestamp(1, now);
            z.executeUpdate();
            
            String umiestenie = "UPDATE umiestnenie SET spravne = "
                    + " CASE floor(random()*3)"
                    + " WHEN 0 THEN 1 "
                    + " WHEN 1 THEN 2 "
                    + " WHEN 2 THEN 3 "
                    + "END"
                    + " WHERE spravne IS NULL AND id_udalost in (SELECT u.id FROM udalost u WHERE datum_konania < ?)";
            
            PreparedStatement u = DbContext.getConnection().prepareStatement(umiestenie);
            u.setTimestamp(1, now);
            u.executeUpdate();
            
            String pocet = "UPDATE pocetgolov SET spravne = "
                    + " CASE floor(random()*4)"
                    + " WHEN 0 THEN 1 "
                    + " WHEN 1 THEN 2 "
                    + " WHEN 2 THEN 3 "
                    + " WHEN 3 THEN 4 "
                    + "END"
                    + " WHERE spravne IS NULL AND id_udalost in (SELECT u.id FROM udalost u WHERE datum_konania < ?)";
            
            PreparedStatement p = DbContext.getConnection().prepareStatement(pocet);
            p.setTimestamp(1, now);
            p.executeUpdate();
            
            vyhodnot();
            System.out.println("Udalosti a tikety boli uspesne vyhodnotene");
            
            
        } catch (SQLException ex) {
            Logger.getLogger(MenuKancelaria.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Udalosti neboli uspesne vyhodnotene");
        }
    }

    private void vyhodnot() {
        try {
            String zapasy1 = "UPDATE tiket SET stav = 1"
                    + " WHERE stav IS NULL and id_udalost in (SELECT z.id_udalost FROM zapas z WHERE z.spravne=tiket.tip)";
            PreparedStatement z1 = DbContext.getConnection().prepareStatement(zapasy1);
            z1.executeUpdate();
            
            String zapasy2 = "UPDATE tiket SET stav = 2"
                    + " WHERE stav IS NULL and id_udalost in (SELECT z.id_udalost FROM zapas z WHERE z.spravne!=tiket.tip)";
            PreparedStatement z2 = DbContext.getConnection().prepareStatement(zapasy2);
            z2.executeUpdate();
            
            String umiestnenie1 = "UPDATE tiket SET stav = 1"
                    + " WHERE stav IS NULL and id_udalost in (SELECT u.id_udalost FROM umiestnenie u WHERE u.spravne=tiket.tip)";
            PreparedStatement u1 = DbContext.getConnection().prepareStatement(umiestnenie1);
            u1.executeUpdate();
            
            String umiestnenie2 = "UPDATE tiket SET stav = 2"
                    + " WHERE stav IS NULL and id_udalost in (SELECT u.id_udalost FROM umiestnenie u WHERE u.spravne!=tiket.tip)";
            PreparedStatement u2 = DbContext.getConnection().prepareStatement(umiestnenie2);
            u2.executeUpdate();
            
            String pocet1 = "UPDATE tiket SET stav = 1"
                    + " WHERE stav IS NULL and id_udalost in (SELECT p.id_udalost FROM pocetgolov p WHERE p.spravne=tiket.tip)";
            PreparedStatement p1 = DbContext.getConnection().prepareStatement(pocet1);
            p1.executeUpdate();
            
            String pocet2 = "UPDATE tiket SET stav = 2"
                    + " WHERE stav IS NULL and id_udalost in (SELECT p.id_udalost FROM pocetgolov p WHERE p.spravne!=tiket.tip)";
            PreparedStatement p2 = DbContext.getConnection().prepareStatement(pocet2);
            p2.executeUpdate();
        } catch (SQLException ex) {
            Logger.getLogger(MenuKancelaria.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Tikety neboli uspesne vyhodnotene");
        }
        
    }

    private void stavKonta() throws SQLException {
        System.out.println("Stav vasho konta je: " + NajdiKancelaria.getInstance().findById(id).getKredit() +"€");
    }
    private void vkladKreditu() throws SQLException, ParseException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));        
        System.out.print("Zadajte kolko chcete dobit na konto: ");
        try {
            int suma = Integer.parseInt(br.readLine());
            UrobOperaciu.getInstance().urobVkladKanc(suma);
            System.out.print("Vas kredit bol navyseny o " + suma + "€");
        
        } catch (IOException | TiketException ex) {
            Logger.getLogger(MenuKancelaria.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Zla suma");
        }
     }

    private void najstavkovanejsiaUdalost() {
        try {
             for (Udalosti udalost : NajdiUdalost.getInstance().findNaj()) {                            
                PonukaPrinter.getInstance().print(udalost);
                if(NajdiZapas.getInstance().findByIdBool(udalost.getId())){                    
                    KurzyZapasPrinter.getInstance().print(udalost.getId());
                }                              
                if(NajdiUmiestnenie.getInstance().findByIdBool(udalost.getId())){
                    KurzyUmiestneniePrinter.getInstance().print(udalost.getId());
                }               
                if(NajdiPocetGolov.getInstance().findByIdBool(udalost.getId())){
                    KurzyPocetGolovPrinter.getInstance().print(udalost.getId());
                }       
            }
        } catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
        }
    }

    private void najlepsiTiper() throws SQLException {
        System.out.println("Najlepsi tiperi");
        for (Uzivatelia naj : NajdiUzivatela.getInstance().findNaj()){  
            System.out.println("ID: "+ naj.getId());
            System.out.println("Meno: "+ naj.getMeno());
            System.out.println("Priezvisko: "+ naj.getPriezvisko());
            System.out.println("Body: "+ naj.getBod());        
            System.out.println();
        }
    }

    private void najlepsiBookmaker() throws SQLException {
        System.out.println("Najlepsi bookmakeri");        
        for (Bookmakers naj : NajdiBookmaker.getInstance().findNaj()){      
            System.out.println("ID: "+ naj.getId());
            System.out.println("Meno: "+ naj.getMeno());
            System.out.println("Priezvisko: "+ naj.getPriezvisko());
            System.out.println("Zetony: "+ naj.getZetony());
            System.out.println();
        }
    
    }
}
