#include <string.h>

#include "put-utils.h"

enum { fieldname_width = 14, bytes_per_line = 32 };

static void put_spaces(FILE *f, int n) {
    if(n < 1) n = 1;
    for(int i = 0; i < n; i++) fputc(' ', f);
}

void put_hex_field(FILE *f, const char *fieldname, 
    const void *some_buf, int len) { 
    const unsigned char *buf = some_buf;  
    int fn_len, i; 

    fn_len = strlen(fieldname); 
    fputs(fieldname, f);
    put_spaces(f, fieldname_width - fn_len);
    for(i = 0; i < len; i++) {
        fprintf(f, "%02x", buf[i]);
        if(!((i+1) % bytes_per_line)) {
            fprintf(f, "\n");
            if(i < len-1) put_spaces(f, fieldname_width);
        }
    }
    if(i % bytes_per_line) fprintf(f, "\n");
}

void put_string_field(FILE *f, const char *fieldname, const char *str) {
    fprintf(f, "%-*s %s\n", fieldname_width-1, fieldname, str);
} 

void put_int_field(FILE *f, const char *fieldname, int value) {
    fprintf(f, "%-*s %d\n", fieldname_width-1, fieldname, value);
} 
