#include <unistd.h>
#include <fcntl.h>

#include "utils.h"


int get_random(void *buf, int len) {
    int fd, rc, cnt;
    fd = open("/dev/urandom", O_RDONLY);
    if(fd == -1) return 0;
    cnt = 0;
    while(cnt < len) {
        rc = read(fd, ((char*)buf) + cnt, len - cnt);
        if(rc < 1) { close(fd); return 0; }
        cnt += rc;
    }
    close(fd);
    return 1;
}

void increment_buf(unsigned char *buf, int len) {
    int i = 0;
    (*buf)++;
    while (buf[i] == 0 && i < len - 1) { i++; buf[i]++; }
}

int all_zeroes(const unsigned char *buf, int len) {
    for (int i = 0; i < len; i++) {
        if (buf[i]) return 0;
    }
    return 1;
}

unsigned long long pack_index(const unsigned char *data) {
    unsigned long long res = 0;
    for (int i = 0; i < 8; i++) {
        res <<=8;
        res |= data[7 - i];
    } 
    return res;
}
