#include <yespower/yespower.h>

#include "crypto-conf.h"
#include "yeswrap.h"



static yespower_local_t yes_local;
static yespower_params_t yes_params;
static int yes_local_initialized = 0;

int take_hash(unsigned char hash[], 
                       const unsigned char src[]) {
    int res, i;
    yespower_binary_t buf;
    if(!yes_local_initialized) {
        yespower_init_local(&yes_local);
        yes_params.version = YESPOWER_1_0;
        yes_params.r = yespower_param_r_value;
        yes_params.N = yespower_param_n_value;
        yes_params.pers = NULL;
        yes_params.perslen = 0;
        yes_local_initialized = 1;
    }
    res = yespower(&yes_local, src, 
                    public_key_size, &yes_params, &buf);
    for(i = 0; i < hash_size; i++) hash[i] = buf.uc[i];
    return res == 0;
}
