import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;



public class DatalogTest {
    public static void testDatalogParser() {
        String inputString = "path(X,Y).\n" +
                "edge(X):-\\+path(X,Y).\n" +
                "query_predicate?";

        datalogLexer lexer = new datalogLexer(CharStreams.fromString(inputString));
        ANTLRErrorListener lexerlistener = new ConsoleErrorListener();
        lexer.addErrorListener(lexerlistener);

        CommonTokenStream tokens = new CommonTokenStream(lexer);
        datalogParser parser = new datalogParser(tokens);
        ParseTree tree = parser.program();


       /* System.out.println(tree.toStringTree(parser));
        System.out.println(lexer._input.getText(Interval.of(0,inputString.length())));*/

        ParseTreeWalker walker = new ParseTreeWalker();
        RelAlgListener listener =  new RelAlgListener();
        walker.walk(listener, tree);
        System.out.println(listener.value);

//Stream.of().collect(Collectors.joining(",","JOIN(",")"));

    }
    public static void main(String[] args) {
            testDatalogParser();
    }
}
