grammar datalog;

program
   : statement* EOF
   ;

statement
   : assertion
   | query
   ;

assertion
   : clause '.'
   ;

query
   : literal '?'
   ;

clause
   : literal ':-' body
   | literal
   ;

body
   : literal ',' body
   | '\\' '+' literal ',' body
   | '\\' '+' literal
   | literal
   ;

literal
   : predicate_sym '(' ')'
   | predicate_sym '(' terms_ ')'
   | predicate_sym
   ;

predicate_sym
   : IDENTIFIER
   ;

terms_
   : term_
   | term_ ',' terms_
   ;

term_
   : VARIABLE
   | constant
   | functionsym
   ;

constant
   : IDENTIFIER
   | INTEGER
   ;

functionsym
    : predicate_sym '(' terms_ ')'
    ;
VARIABLE
   : [A-Z]+
   ;

IDENTIFIER
   : [a-z] [a-zA-Z0-9_-]*
   ;

INTEGER
   : [0-9]+
   ;

WS
   : [ \r\n\t]+ -> skip
   ;