import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;



public class DatalogTest {
    public static void errorInProgram(){
        //There is no . in the end of the rule.
        String inputString = "path(X, Y):- edge(X, Z), edge(Z,Y)\n" +
                "path(X, Y)?";

        datalogLexer lexer = new datalogLexer(CharStreams.fromString(inputString));
        ANTLRErrorListener lexerlistener = new ConsoleErrorListener();
        lexer.addErrorListener(lexerlistener);

        CommonTokenStream tokens = new CommonTokenStream(lexer);
        datalogParser parser = new datalogParser(tokens);
        ParseTree tree = parser.program();


        ParseTreeWalker walker = new ParseTreeWalker();
        RelAlgListener listener =  new RelAlgListener();
        walker.walk(listener, tree);
        System.out.println(listener.result());
    }

    public static void testJoinAntijoin() {
        String inputString = "path(X, Y):- edge(X, Z), edge(Z,Y), \\+c(X).\n" +
                "path(X, Y)?";

        datalogLexer lexer = new datalogLexer(CharStreams.fromString(inputString));
        ANTLRErrorListener lexerlistener = new ConsoleErrorListener();
        lexer.addErrorListener(lexerlistener);

        CommonTokenStream tokens = new CommonTokenStream(lexer);
        datalogParser parser = new datalogParser(tokens);
        ParseTree tree = parser.program();


        ParseTreeWalker walker = new ParseTreeWalker();
        RelAlgListener listener =  new RelAlgListener();
        walker.walk(listener, tree);
        System.out.println(listener.result());
    }

    public static void testnoneExistingQuery(){
        String inputString = "path(X, Y):- edge(X, Z), edge(Z,Y).\n" +
                "color(X)?";

        datalogLexer lexer = new datalogLexer(CharStreams.fromString(inputString));
        ANTLRErrorListener lexerlistener = new ConsoleErrorListener();
        lexer.addErrorListener(lexerlistener);

        CommonTokenStream tokens = new CommonTokenStream(lexer);
        datalogParser parser = new datalogParser(tokens);
        ParseTree tree = parser.program();


        ParseTreeWalker walker = new ParseTreeWalker();
        RelAlgListener listener =  new RelAlgListener();
        walker.walk(listener, tree);
        System.out.println(listener.result());
    }
    public static void testUnion(){

        String inputString = "path(X,Y):- edge(X,Y), \\+c(X), \\+c(Y)." +
                "path(X, Y):- edge(X, Z), edge(Z,Y).\n" +
                "path(X, Y)?";
        datalogLexer lexer = new datalogLexer(CharStreams.fromString(inputString));
        ANTLRErrorListener lexerlistener = new ConsoleErrorListener();
        lexer.addErrorListener(lexerlistener);

        CommonTokenStream tokens = new CommonTokenStream(lexer);
        datalogParser parser = new datalogParser(tokens);
        ParseTree tree = parser.program();


        ParseTreeWalker walker = new ParseTreeWalker();
        RelAlgListener listener =  new RelAlgListener();
        walker.walk(listener, tree);
        System.out.println(listener.result());
    }
    public static void main(String[] args) {

        System.out.println("testing compiler...");
        errorInProgram();
        System.out.println("========================");
        System.out.println("testing Join and AntiJoin...");
        testJoinAntijoin();
        System.out.println("========================");
        System.out.println("testing undefined predicate...");
        testnoneExistingQuery();
        System.out.println("========================");
        System.out.println("testing union...");
        testUnion();
    }
}
