import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RelAlgListener implements datalogListener{
    private String value;
    private Map<String, ArrayList<String>> joins;
    private Map<String, ArrayList<String>> antijoins;
    private ArrayList<String> curJoinsUnion;
    private ArrayList<String> curAntiJoinsUnion;
    private Map<String,  ArrayList<String>> unions;
    private ArrayList<String> predicates;
    private String curPred;
    private boolean isUnion;

    public RelAlgListener(){
        predicates = new ArrayList<>();
        joins = new HashMap<>();
        antijoins = new HashMap<>();
        unions= new HashMap<>();
        isUnion=false;
    }

    public String result() {
        StringBuilder stringBuilder = new StringBuilder();
        if(!joins.containsKey(value)){
            return "There is no such predicate in your datalog program.";
        }
        stringBuilder.append(value+" = ");
        stringBuilder.append("REC("+value+", ");
        stringBuilder.append("UNION(");
        stringBuilder.append(joins.get((value)).stream().collect(Collectors.joining(",","JOIN(",")")));
        stringBuilder.append(",");
        stringBuilder.append(antijoins.get((value)).stream().collect(Collectors.joining(",","ANTIJOIN(",")")));
        if(!antijoins.get(value).isEmpty()) stringBuilder.append(")");
        if(!unions.get(value).isEmpty()) {
           stringBuilder.append(",");
            stringBuilder.append(unions.get((value)).stream().collect(Collectors.joining(",")));
        }
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
    @Override
    public void enterProgram(datalogParser.ProgramContext ctx) {

    }

    @Override
    public void exitProgram(datalogParser.ProgramContext ctx) {

    }

    @Override
    public void enterStatement(datalogParser.StatementContext ctx) {

    }

    @Override
    public void exitStatement(datalogParser.StatementContext ctx) {

    }

    @Override
    public void enterAssertion(datalogParser.AssertionContext ctx) {

    }

    @Override
    public void exitAssertion(datalogParser.AssertionContext ctx) {

    }

    @Override
    public void enterQuery(datalogParser.QueryContext ctx) {
        char[] context = ctx.getText().toCharArray();
        value = String.valueOf(context[0]);
        for(int i = 1; i < context.length-1; i++){
            value += context[i];
        }
    }

    @Override
    public void exitQuery(datalogParser.QueryContext ctx) {

    }

    @Override
    public void enterClause(datalogParser.ClauseContext ctx) {


        char[] context = ctx.getText().toCharArray();
        curPred = String.valueOf(context[0]);
        for(int i = 1; i < context.length-1; i++){
            if(context[i]==':' &&  context[i+1]=='-') {
                if(joins.containsKey(curPred)){
                    isUnion = true;
                    curAntiJoinsUnion = new ArrayList<>();
                    curJoinsUnion = new ArrayList<>();
                }
                else{
                    joins.put(curPred, new ArrayList<>());
                    antijoins.put(curPred, new ArrayList<>());
                    unions.put(curPred, new ArrayList<>());
                }
                predicates.add(curPred);
                break;
            }
             curPred+= context[i];

        }
    }

    @Override
    public void exitClause(datalogParser.ClauseContext ctx) {
        if(isUnion){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(curJoinsUnion.stream().collect(Collectors.joining(",","JOIN(",")")));
            stringBuilder.append(",");
            stringBuilder.append(curAntiJoinsUnion.stream().collect(Collectors.joining(",","ANTIJOIN(",")")));
            ArrayList<String> l = unions.get(curPred);
            l.add(stringBuilder.toString());
            unions.put(curPred, l);
            isUnion=false;
            curJoinsUnion = new ArrayList<>();
            curAntiJoinsUnion = new ArrayList<>();
        }
    }

    @Override
    public void enterBody(datalogParser.BodyContext ctx) {

        boolean negation = false;
        char[] context = ctx.getText().toCharArray();
        String res;
        if(context[0]=='\\') {
            negation = true;
            res = String.valueOf(context[2]);
        }
        else{
            res = String.valueOf(context[0]);
        }
        int i =1;
        if(negation) i=3;
        for(; i < context.length-1; i++){
            if(context[i]==',') {
                if(context.length==i) break;
                if(!(context[i+1]>=65 && context[i+1]<=90)) break;
            }
            res+=context[i];
        }
        if(negation){
            if(isUnion){
                curAntiJoinsUnion.add(res);
            }
            else{
                ArrayList<String> l = antijoins.get(curPred);
                l.add(res);
                antijoins.put(curPred, l);
            }

        }
        else{
            if(isUnion){
                curJoinsUnion.add(res);
            }
            else{
                ArrayList<String> l = joins.get(curPred);
                l.add(res);
                joins.put(curPred, l);
            }

        }

    }

    @Override
    public void exitBody(datalogParser.BodyContext ctx) {

    }

    @Override
    public void enterLiteral(datalogParser.LiteralContext ctx) {

    }

    @Override
    public void exitLiteral(datalogParser.LiteralContext ctx) {

    }

    @Override
    public void enterPredicate_sym(datalogParser.Predicate_symContext ctx) {

    }

    @Override
    public void exitPredicate_sym(datalogParser.Predicate_symContext ctx) {
        predicates.add(ctx.getText());
    }

    @Override
    public void enterTerms_(datalogParser.Terms_Context ctx) {

    }

    @Override
    public void exitTerms_(datalogParser.Terms_Context ctx) {

    }

    @Override
    public void enterTerm_(datalogParser.Term_Context ctx) {

    }

    @Override
    public void exitTerm_(datalogParser.Term_Context ctx) {

    }

    @Override
    public void enterConstant(datalogParser.ConstantContext ctx) {

    }

    @Override
    public void exitConstant(datalogParser.ConstantContext ctx) {

    }

    @Override
    public void enterFunctionsym(datalogParser.FunctionsymContext ctx) {

    }

    @Override
    public void exitFunctionsym(datalogParser.FunctionsymContext ctx) {

    }

    @Override
    public void visitTerminal(TerminalNode terminalNode) {

    }

    @Override
    public void visitErrorNode(ErrorNode errorNode) {

    }

    @Override
    public void enterEveryRule(ParserRuleContext parserRuleContext) {

    }

    @Override
    public void exitEveryRule(ParserRuleContext parserRuleContext) {

    }
}
