# eBPF nástroj

## Dependencie

Ubuntu (a debianové systémy)
```bash
sudo apt install clang libbpf-dev linux-tools-$(uname -r) gcc make linux-headers-$(uname -r)
```

CentOS
```bash
sudo dnf install bpftool libbpf-devel clang gcc make kernel-headers
```

## Kompilácia
```bash
make
```

## Spustenie
```bash
sudo ./main
```
alebo
```
make run
```

## Prepínače

- `-h` - help
- `-c, --csv` - výstup vo formáte csv
- `-f FILE, --file FILE` - výstup zapíš do súbora `FILE`
- `-F param1,param2,...`, `--filter param1,param2,...` - filtruje parametre
- `-C, --cumulative` - vypíš kumulatívne hodnoty pre `utime`, `stime`,
  `inblock`, `oublock`, odfiltruje `cutime`, `cstime`, `cinblock`,
  `coublock`
- `-u UID, --uid UID` - vypíš údaje len od procesov, ktoré vlastní
  používateľ s uid UID

povolené hodnoty parametrov pre filter:
- pcomm
- tgid
- pid
- ppid
- uid
- age
- utime
- stime
- exit
- exitsig
- nvcs
- nivcs
- cutime
- cstime
- inblock
- oublock
- cinblock
- coublock

## Príklad použitia
```bash
sudo ./main -F pcomm,ppid,utime,exit
```

# Štatistický program

## Spustenie
```bash
python stats.py [FILE]
```
alebo
```bash
./stats.py [FILE]
```

## Prepínače

- `-h` - help
- `-i N` - veľkosť intervalu v histograme (defaultne 1)
- `-r {linear,exponential}` - rýchlosť rastu veľkosti intervalu v
  histograme (defaultne linear)
- `-f FILTER` - filter pre histogramy, čiarkou oddelený zoznam
  parametrov

FILTER má tvar `param1,param2,...,paramN`, napr. `age,utime,stime`,
povolené hodnoty parametrov sú:
- age
- utime
- stime
- nvcsw
- nivcsw
- cutime
- cstime
- inblk
- oublk
- cinblk
- coublk
- uid
- exit
- exitsig

## Príklad použitia
```bash
python stats.py -i 10 -r linear zaznam.txt
```
