#include "vmlinux.h"
#include <bpf/bpf_tracing.h>
#include <bpf/bpf_helpers.h>
#include "process_exit.h"

struct {
   __uint(type, BPF_MAP_TYPE_PERF_EVENT_ARRAY);
   __uint(key_size, sizeof(u32));
   __uint(value_size, sizeof(u32));
} output SEC(".maps");

SEC("tracepoint/sched/sched_process_exit")
int sched_process_exit(void* ctx)
{
    struct task_struct* task = (typeof(task))bpf_get_current_task();
    struct data_t data = {};

    bpf_probe_read_kernel(&data.start_time, sizeof(data.start_time), &task->start_time);
    data.exit_time = bpf_ktime_get_ns(),
    bpf_probe_read_kernel(&data.utime, sizeof(data.utime), &task->utime);
    bpf_probe_read_kernel(&data.stime, sizeof(data.stime), &task->stime);
    bpf_probe_read_kernel(&data.tgid, sizeof(data.tgid), &task->tgid);
    bpf_probe_read_kernel(&data.pid, sizeof(data.pid), &task->pid);

    struct task_struct* real_parent = NULL;
    bpf_probe_read_kernel(&real_parent, sizeof(struct task_struct*), &task->real_parent);
    bpf_probe_read_kernel(&data.ppid, sizeof(data.ppid), &real_parent->pid);

    struct cred* real_cred = NULL;
    bpf_probe_read_kernel(&real_cred, sizeof(struct cred*), &task->real_cred);
    bpf_probe_read_kernel(&data.uid, sizeof(data.uid), &real_cred->uid);

    bpf_probe_read_kernel(&data.exit_code, sizeof(data.exit_code), &task->exit_code);
    bpf_probe_read_kernel(&data.exit_signal, sizeof(data.exit_signal), &task->exit_signal);
    bpf_probe_read_kernel(&data.nvcsw, sizeof(data.nvcsw), &task->nvcsw);
    bpf_probe_read_kernel(&data.nivcsw, sizeof(data.nivcsw), &task->nivcsw);

    struct signal_struct* sig = NULL;
    bpf_probe_read_kernel(&sig, sizeof(struct signal_struct*), &task->signal);
    bpf_probe_read_kernel(&data.cutime, sizeof(data.cutime), &sig->cutime);
    bpf_probe_read_kernel(&data.cstime, sizeof(data.cstime), &sig->cstime);
    bpf_probe_read_kernel(&data.inblock, sizeof(data.inblock), &sig->inblock);
    bpf_probe_read_kernel(&data.oublock, sizeof(data.oublock), &sig->oublock);
    bpf_probe_read_kernel(&data.cinblock, sizeof(data.cinblock), &sig->cinblock);
    bpf_probe_read_kernel(&data.coublock, sizeof(data.coublock), &sig->coublock);

    struct task_io_accounting* ioac = NULL;
    bpf_probe_read_kernel(&ioac, sizeof(struct ioac_accounting*), &task->ioac);
    __u64 read = 0;
    __u64 written = 0;
    bpf_probe_read_kernel(&read, sizeof(read), &ioac->read_bytes);
    bpf_probe_read_kernel(&written, sizeof(written), &ioac->write_bytes);
    data.inblock += read >> 9;
    data.oublock += written >> 9;

    bpf_get_current_comm(&data.task, sizeof(data.task));

    bpf_perf_event_output(ctx, &output, BPF_F_CURRENT_CPU,
                          &data, sizeof(data));

    return 0;
}

char LICENSE[] SEC("license") = "Dual BSD/GPL";
