import joblib
from MLProblemEvaluation import plot_feature_comparison, plot_feature_importance, plot_confusion_matrix, analyze_feature_categories

# Load saved results
results = joblib.load('ml_results.joblib')

X = results['X']
y = results['y']
model = results['model']
le = results['le']
X_train = results['X_train']
X_test = results['X_test']
y_train = results['y_train']
y_test = results['y_test']
y_pred = results['y_pred']

# Show feature comparison (pie/bar chart)
hold_difficulty_percent, spatial_percent, _ = analyze_feature_categories(X, model)
plot_feature_comparison(hold_difficulty_percent, spatial_percent)

# Show feature importance plot
plot_feature_importance(X, model)

# Show confusion matrix plot
plot_confusion_matrix(y_test, y_pred, le)