# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="Matej Pechac"
__date__ ="$Dec 9, 2010 12:09:00 PM$"

from pybrain.structure.networks.recurrent import RecurrentNetwork
from pybrain.structure.modules import BiasUnit, SigmoidLayer, LinearLayer
from pybrain.structure.connections import FullConnection

class ElmanNetwork(RecurrentNetwork):
    def __init__(self, *layer):
        if len(layer) < 3:
            raise NetworkError('Elman network needs 3 arguments for input,hidden and output layers at least.')

        print 'Elman network'
        RecurrentNetwork.__init__(self)
        self.addInputModule(LinearLayer(layer[0], name = "input"))
        self.addOutputModule(LinearLayer(layer[-1], name = "output"))
        self.addModule(BiasUnit(name='bias'))
        self.addConnection(FullConnection(self['bias'], self['output'], name = 'bias_output'))
        for i,n in enumerate(layer[1:-1]):
            layername = 'hidden%i' % i
            self.addModule(SigmoidLayer(n, name=layername))
            self.addConnection(FullConnection(self['bias'], self[layername], name = 'bias_%s' % layername))

        self.addModule(SigmoidLayer(layer[1], name='context'))
        
        for i in range(len(layer)-3):
            self.addConnection(FullConnection(self['hidden%i' % i], self['hidden%i' % (i + 1)], name = 'hidden%i_hidden%i' % (i, i+1)))

        self.addConnection(FullConnection(self['input'], self['hidden0'], name = 'input_hidden'))
        self.addConnection(FullConnection(self['hidden%i' % (len(layer) - 3)], self['output'], name = 'hidden_ouput'))
        
        self.addRecurrentConnection(FullConnection(self['hidden0'], self['context'], name = 'reccurent'))
        self.addConnection(FullConnection(self['context'], self['hidden0'], name = 'context_hidden'))
        self.sortModules()

        self.params[:] *= 0.01
