# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="matej"
__date__ ="$Dec 9, 2010 1:36:43 PM$"

from pybrain.structure.networks.recurrent import RecurrentNetwork
from pybrain.structure.modules import BiasUnit, SigmoidLayer, LinearLayer
from pybrain.structure.connections import FullConnection

class JordanNetwork:
    def __init__(self, *layer):
        if len(layer) < 3:
            raise NetworkError('Jordan network needs 3 arguments for input,hidden and output layers at least.')

        self.network = RecurrentNetwork()
        self.network.addInputModule(LinearLayer(layer[0], name = "input"))
        self.network.addOutputModule(LinearLayer(layer[-1], name = "output"))
        self.network.addModule(BiasUnit(name='bias'))
        self.network.addConnection(FullConnection(self.network['bias'], self.network['output']))
        for i,n in enumerate(layer[1:-1]):
            layername = 'hidden%i' % i
            self.network.addModule(SigmoidLayer(n, name=layername))
            self.network.addConnection(FullConnection(self.network['bias'], self.network[layername]))

        self.network.addModule(SigmoidLayer(layer[-1], name='context'))

        for i in range(len(layer)-3):
            self.network.addConnection(FullConnection(self.networkn['hidden%i' % i], self.network['hidden%i' % (i + 1)]))

        self.network.addConnection(FullConnection(self.network['input'], self.network['hidden0']))
        self.network.addConnection(FullConnection(self.network['hidden%i' % (len(layer) - 3)], self.network['output']))

        self.network.addRecurrentConnection(FullConnection(self.network['output'], self.network['context']))
        self.network.addConnection(FullConnection(self.network['context'], self.network['hidden0']))
        self.network.sortModules()
