# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="Matej Pechac"
__date__ ="$Feb 22, 2011 12:06:32 PM$"

from pybrain.structure.networks.feedforward import FeedForwardNetwork
from pybrain.structure.modules import LinearLayer
from pybrain.structure.connections import FullConnection

class UnfoldedNetwork(FeedForwardNetwork):
    def __init__(self, network, sequence):
        import Queue
        from copy import deepcopy

        FeedForwardNetwork.__init__(self)

        queue_context = Queue.Queue()
        queue_connection_context = Queue.Queue()

        t = 0

        for i in range(len(sequence)):
            queue_context.put(deepcopy(network.__getitem__('context')))
            queue_connection_context.put(deepcopy(network.connections[network.__getitem__('context')][0]))
            t = t + 1

        output = deepcopy(network.__getitem__('output'))
        self.addOutputModule(output)

        hidden = deepcopy(network.__getitem__('hidden0'))
        hidden.name = 'hidden%i' % t
        self.addModule(hidden)

        con_hidden_output = deepcopy(network.connections[network.__getitem__('hidden0')][0])
        con_hidden_output.inmod = hidden
        con_hidden_output.outmod = output
        self.addConnection(con_hidden_output)

        while (not queue_context.empty()):
            t = t -1

            hidden = queue_context.get()
            hidden.name = 'hidden%i' % t
            self.addModule(hidden)
            connection = queue_connection_context.get()
            connection.inmod = hidden
            connection.outmod = self.__getitem__('hidden%i' % (t+1))
            connection.name = 'hidden%i_hidden%i' % (t, t +1)
            self.addConnection(connection)

            self.addInputModule(LinearLayer(network.__getitem__('input').indim, name = 'input%i' % t))
            self.addConnection(FullConnection(self['input%i' % t], self['hidden%i' % (t+1)], name = 'input%i_hidden%i' % (t, t +1)))

        self.sortModules()

        #print self
