import GUI
import neuralNet

class App():
    network = None
    
    def __init__(self):
        self.GUI = GUI.GUI(self)

    def main(self):
        self.GUI.main()

    def new_neural_network(self, data = None):
        self.network = neuralNet.neuralNetwork(self, data)

    def load_data_set(self):
        if self.network != None:
            self.network.onLoadDataSet()

    def start_training(self):
        if self.network != None:
            learning_rate = self.GUI.get_learning_rate()
            weightdecay = self.GUI.get_weight_decay()
            if weightdecay < 0:
                weightdecay = 0.0
            momentum = self.GUI.get_momentum()
            if momentum < 0:
                momentum = 0.0
            learning_decay = self.GUI.get_learning_decay()
            if learning_decay < 0:
                learning_decay = 1.0
            
            self.network.onTrain(self.GUI.get_learning_algorithm(), learning_rate, learning_decay, momentum, weightdecay)

    def start_testing(self):
        if self.network != None:
            self.network.onTest()

                
if __name__ == '__main__':
    app = App()
    
    app.main()