# To change this template, choose Tools | Templates
# and open the template in the editor.

from scipy import reshape, dot, outer
from random import random

from pybrain.structure.connections.connection import Connection
from pybrain.structure.parametercontainer import ParameterContainer
from pyamg.util.linalg import approximate_spectral_radius


class ReservoirConnection(Connection, ParameterContainer):
    
    def __init__(self, *args, **kwargs):
        from numpy import matrix
        
        Connection.__init__(self, *args, **kwargs)
        ParameterContainer.__init__(self, self.indim*self.outdim)
        self._sparseMatrix()
        print approximate_spectral_radius(matrix(self.W))

    def _forwardImplementation(self, inbuf, outbuf):
        outbuf += dot(reshape(self.params, (self.outdim, self.indim)), inbuf)

    def _backwardImplementation(self, outerr, inerr, inbuf):
        inerr += dot(reshape(self.params, (self.outdim, self.indim)).T, outerr)
        ds = self.derivs
        ds += outer(inbuf, outerr).T.flatten()

    def whichBuffers(self, paramIndex):
        """Return the index of the input module's output buffer and
        the output module's input buffer for the given weight."""
        return paramIndex % self.inmod.outdim, paramIndex / self.inmod.outdim

    def _sparseMatrix(self, sparseness = 0.2):
        self.W = []
        for i in range(self.indim):
            row = []
            for j in range(self.outdim):
                if random() > sparseness:
                    self.params[i*self.indim + j] = 0
                else:
                    self.params[i*self.indim + j] *= 0.8
                row.append(self.params[i*self.indim + j])
            self.W.append(row)