package main.java.rdg;

import main.java.DbConnection;

import java.sql.*;
import java.util.HashSet;
import java.util.Set;

public class Customer {
    private long id;
    private String firstName;
    private String lastName;
    private Date dateOfBirth;
    private String email;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString(){
        return firstName + " " + lastName +
                "{" + id + "}, DOB: " + dateOfBirth +
                ", " + email;
    }

    public boolean create () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("INSERT INTO customers (firstname, lastname, dateofbirth, email) VALUES (?, ?, ?, ?)", Statement.RETURN_GENERATED_KEYS)){
            s.setString(1, firstName);
            s.setString(2, lastName);
            s.setDate(3, dateOfBirth);
            s.setString(4, email);

            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()){
                r.next();
                this.id=r.getLong(1);;
            }

        } catch (SQLException e){
            return false;
        }
        return true;
    }

    public static Customer read (long id){
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM customers WHERE customer_id=?")){
            s.setLong(1, id);

            Customer customer = new Customer();

            try (ResultSet r = s.executeQuery()){
                r.next();
                customer.setId(r.getLong(1));
                customer.setFirstName(r.getString(2));
                customer.setLastName(r.getString(3));
                customer.setDateOfBirth(r.getDate(4));
                customer.setEmail(r.getString(5));
            }

            return customer;

        } catch (SQLException e) {
            return null;
        }
    }

    public boolean update () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("UPDATE customers SET firstname=?, lastname=?, email=? WHERE customer_id=?")){
            s.setString(1, firstName);
            s.setString(2, lastName);
            s.setString(3, email);
            s.setLong(4, id);

            s.executeUpdate();
        }catch (SQLException e) {
            return false;
        }
        return true;
    }

    public boolean delete (){
        try (PreparedStatement ss = DbConnection.getCon().prepareStatement("DELETE FROM customers WHERE customer_id=?")) {
            ss.setLong(1, id);
            ss.executeUpdate();

        } catch (SQLException e){
            return false;
        }
        return true;
    }

    public static Set<Customer> listAll () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM customers")){
            Set<Customer> customers = new HashSet<>();

            try (ResultSet r = s.executeQuery()) {
                while (r.next()) {
                    Customer c = new Customer();
                    c.setId(r.getLong(1));
                    c.setFirstName(r.getString(2));
                    c.setLastName(r.getString(3));
                    c.setDateOfBirth(r.getDate(4));
                    c.setEmail(r.getString(5));

                    customers.add(c);
                }
            }

            return customers;
        } catch (SQLException e) {
            return null;
        }
    }
}
