package main.java.rdg;

import main.java.DbConnection;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class Price {
    private long id;
    private double value;
    private String customerType;
    private String screeningType;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public double getValue() {return value;}

    public void setValue(double value) {this.value = value;}

    public String getCustomerType() {
        return customerType;
    }

    public void setCustomerType(String customerType) {
        this.customerType = customerType;
    }

    public String getScreeningType() {
        return screeningType;
    }

    public void setScreeningType(String screeningType) {
        this.screeningType = screeningType;
    }

    @Override
    public String toString() {
        return "Price{" +
                "id=" + id +
                ", value=" + value +
                ", customerType='" + customerType + '\'' +
                ", screeningType='" + screeningType + '\'' +
                '}';
    }

    public boolean create () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("INSERT INTO prices (value, customertype, screeningtype) VALUES (?,?,?)", Statement.RETURN_GENERATED_KEYS)){
            s.setDouble(1, value);
            s.setString(2, customerType);
            s.setString(3, screeningType);

            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()){
                r.next();
                this.id=r.getLong(1);;
            }
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Price read (long id) {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM prices WHERE price_id=?")){
            s.setLong(1, id);

            Price price = new Price();

            try (ResultSet r = s.executeQuery()){
                r.next();
                price.setId(r.getLong(1));
                price.setValue(r.getLong(2));
                price.setCustomerType(r.getString(3));
                price.setScreeningType(r.getString(4));
            }

            return price;

        } catch (SQLException e){
            e.printStackTrace();
            return null;
        }
    }

    public boolean update () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("UPDATE prices SET value=? WHERE price_id=?")){
            s.setDouble(1, value);
            s.setLong(2, id);

            s.executeUpdate();

        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;

    }

    public boolean delete () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("DELETE FROM prices WHERE price_id=?")){
            s.setLong(1, id);
            s.executeUpdate();
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Set<Price> listAll () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM prices")){
            Set<Price> prices = new HashSet<>();

            try (ResultSet r = s.executeQuery()) {
                while (r.next()) {
                    Price p = new Price();
                    p.setId(r.getLong(1));
                    p.setValue(r.getDouble(2));
                    p.setCustomerType(r.getString(3));
                    p.setScreeningType(r.getString(4));

                    prices.add(p);
                }
            }

            return prices;
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Price getPrice (String customerType, String screeningType) {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM prices WHERE customertype=? AND screeningtype=?")){
            s.setString(1, customerType);
            s.setString(2, screeningType);

            Price p = new Price();

            try (ResultSet r = s.executeQuery()){
                r.next();
                p.setId(r.getLong(1));
                p.setValue(r.getDouble(2));
                p.setScreeningType(screeningType);
                p.setCustomerType(customerType);
            }

            return p;

        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}
