package main.java.rdg;

import main.java.DbConnection;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Seat {
    private long id;
    private long cinemaHall;
    private int row;
    private int seatNumber;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getCinemaHall() {
        return cinemaHall;
    }

    public void setCinemaHall(long id) {
        this.cinemaHall = id;
    }

    public int getRow() {
        return row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getSeatNumber() {
        return seatNumber;
    }

    public void setSeatNumber(int seatNumber) {
        this.seatNumber = seatNumber;
    }

    @Override
    public String toString() {
        return "Seat{" +
                "id=" + id +
                ", cinemaHall=" + cinemaHall +
                ", row=" + row +
                ", seatNumber=" + seatNumber +
                '}';
    }

    public boolean create (){
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("INSERT INTO seats (hall_id, row, seatnumber) VALUES (?, ?, ?)")){
            long hallID = this.cinemaHall;
            int row = this.row, seat = this.seatNumber;
            s.setLong(1, hallID);
            s.setInt(2, row);
            s.setInt(3, seat);

            s.executeUpdate();
        } catch (SQLException e){
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Seat read (long hallID, int row, int seat) {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM seats WHERE hall_id=? AND row=? AND seatnumber=?")) {
            s.setLong(1, hallID);
            s.setInt(2, row);
            s.setInt(3, seat);

            Seat seatInstance = new Seat();

            try (ResultSet r = s.executeQuery()){
                r.next();
                seatInstance.setId(r.getLong(1));
                seatInstance.setCinemaHall(hallID);
                seatInstance.setRow(row);
                seatInstance.setSeatNumber(seat);
            }

            return seatInstance;
        } catch (SQLException e){
            e.printStackTrace();
            return null;
        }
    }

    public static Seat read (long seatID) {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM seats WHERE seat_id=?")) {
            s.setLong(1, seatID);

            Seat seatInstance = new Seat();

            try (ResultSet r = s.executeQuery()){
                r.next();
                seatInstance.setId(r.getLong(1));
                seatInstance.setCinemaHall(r.getLong(2));
                seatInstance.setRow(r.getInt(3));
                seatInstance.setSeatNumber(r.getInt(4));
            }

            return seatInstance;
        } catch (SQLException e){
            e.printStackTrace();
            return null;
        }
    }

    public boolean delete () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("DELETE FROM seats WHERE seat_id=?")){
            s.setLong(1, this.id);

            s.executeUpdate();
        } catch (SQLException e){
            e.printStackTrace();
            return false;
        }
        return true;
    }
}
