package main.java.ui;

import main.java.rdg.Customer;

import java.sql.Date;
import java.util.GregorianCalendar;

public class CustomerMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION: \n" +
                "1. Add new customer\n" +
                "2. List all\n" +
                "3. Find customer\n" +
                "4. Delete customer\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input){
            case "1": addCustomer(); break;
            case "2": Customer.listAll().forEach(System.out::println); break;
            case "3": find(); break;
            case "4": delete(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addCustomer() {
        String[] input = UserInput.get("Enter customers data [first name; last name; date of birth (YYYY:MM:DD); email").split(";");
        String fname = input[0];
        String lname = input[1];
        String[] date = input[2].split(":");
        String email = input[3];

        GregorianCalendar cal = new GregorianCalendar(Integer.parseInt(date[0]), Integer.parseInt(date[1])-1, Integer.parseInt(date[2]));
        Date dob = new Date(cal.getTimeInMillis());

        Customer c = new Customer();
        c.setFirstName(fname);
        c.setLastName(lname);
        c.setDateOfBirth(dob);
        c.setEmail(email);

        UserInput.success(c.create());
    }

    public static void find() {
        String id = UserInput.get("Enter customer ID");
        Customer customer = Customer.read(Integer.parseInt(id));

        if (customer == null) {
            System.out.println("No such customer ID found");
            return;
        }

        System.out.println(customer);
    }

    public static void delete() {
        String id = UserInput.get("Enter customer ID");
        UserInput.success(Customer.read(Integer.parseInt(id)).delete());
    }
}
