package main.java.ui;

import main.java.rdg.Genre;

public class GenreMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION:\n" +
                "1. Add new genre\n" +
                "2. Change genre name\n" +
                "3. List all genres\n" +
                "4. Delete genre\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        if (input == null){
            System.out.println("Problemo");
            return;
        }

        switch (input){
            case "1": addGenre(); break;
            case "2": updateGenre(); break;
            case "3": listGenre(); break;
            case "4": deleteGenre(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addGenre() {
        String input = UserInput.get("Enter genre name");

        Genre genre = new Genre();
        genre.setName(input);

        UserInput.success(genre.create());
    }

    public static void updateGenre() {
        String input = UserInput.get("Enter genre ID you would like to change");
        int id = Integer.parseInt(input);

        Genre genre = Genre.read(id);
        if (genre == null) {
            System.out.println("No such genre ID found");
            return;
        }

        String newName = UserInput.get("Enter new genre name");
        genre.setName(newName);
        UserInput.success(genre.update());
    }

    public static void listGenre() {
        Genre.listAll().forEach(System.out::println);
    }

    public static void deleteGenre() {
        String input = UserInput.get("Enter genre ID you would like to delete");
        int id = Integer.parseInt(input);

        Genre genre = Genre.read(id);
        if (genre == null) {
            System.out.println("No such genre ID found");
            return;
        }

        UserInput.success(genre.delete());
    }
}
