package main.java.rdg;

import main.java.DbConnection;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class Genre {
    private long id;
    private String name;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "Genre{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }

    public boolean create (){
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("INSERT INTO genres (name) VALUES (?)", Statement.RETURN_GENERATED_KEYS)){
            s.setString(1, name);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()){
                r.next();
                this.id=r.getLong(1);;
            }
        } catch (SQLException e) {
            return false;
        }
        return true;
    }

    public static Genre read (long id){
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM genres WHERE genre_id=?")){
            s.setLong(1, id);

            Genre genre = new Genre();

            try (ResultSet r = s.executeQuery()){
                r.next();
                genre.setId(r.getLong(1));
                genre.setName(r.getString(2));
            }

            return genre;

        } catch (SQLException e){
            return null;
        }
    }

    public boolean update () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("UPDATE genres SET name=? WHERE genre_id=?")) {
            s.setString(1, name);
            s.setLong(2, id);

            s.executeUpdate();

        } catch (SQLException e){
            return false;
        }
        return true;
    }

    public boolean delete () {
        DbConnection.setIsolationCommitted();
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("DELETE FROM genres WHERE genre_id=?")) {
            s.setLong(1, id);
            s.executeUpdate();
        } catch (SQLException e){
            return false;
        }
        return true;
    }

    public static Set<Genre> listAll () {
        try (PreparedStatement s = DbConnection.getCon().prepareStatement("SELECT * FROM genres")){
            Set<Genre> genres = new HashSet<>();

            try (ResultSet r = s.executeQuery()) {
                while (r.next()) {
                    Genre g = new Genre();
                    g.setId(r.getLong(1));
                    g.setName(r.getString(2));

                    genres.add(g);
                }
            }

            return genres;
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}
