package main.java.ui;

import main.java.rdg.CinemaHall;

public class CinemaHallMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION:\n" +
                "1. Add new hall\n" +
                "2. View all halls\n" +
                "3. Delete hall\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input) {
            case "1": addHall(); break;
            case "2": CinemaHall.listAll().forEach(System.out::println); break;
            case "3": delete(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addHall() {
        String label = UserInput.get("Enter hall label");
        int rows = Integer.parseInt(UserInput.get("Enter row count"));
        int seatsPerRow = Integer.parseInt(UserInput.get("Enter seats per row count"));
        String type = UserInput.get("Enter hall type [BASIC/THREE_DIMENSIONAL/SUPER_SCREEN]");

        CinemaHall cinemaHall = new CinemaHall();
        cinemaHall.setHallLabel(label);
        cinemaHall.setRowCount(rows);
        cinemaHall.setSeatsPerRow(seatsPerRow);
        cinemaHall.setScreenType(type);

        UserInput.success(cinemaHall.create());
    }

    public static void delete() {
        long id = Long.parseLong(UserInput.get("Enter hall ID"));
        CinemaHall cinemaHall = CinemaHall.read(id);
        if (cinemaHall == null){
            System.out.println("No such hall ID found");
            return;
        }
        UserInput.success(cinemaHall.delete());
    }
}
