package main.java.ui;

import main.java.rdg.Genre;
import main.java.rdg.Movie;
import main.java.rdg.Screening;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MovieMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION:\n" +
                "1. Add new movie\n" +
                "2. Update a movie (name, length, genres, description)\n" +
                "3. List all movies\n" +
                "4. Find movie\n" +
                "5. Delete movie\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input){
            case "1": addMovie(); break;
            case "2": updateMovie(); break;
            case "3": Movie.listAll().forEach(System.out::println); break;
            case "4": detailPrint(); break;
            case "5": deleteMovie(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addMovie(){
        String[] input = UserInput.get("Enter movie info [name;length in minutes; description").split(";");

        String name = input[0];
        int length = Integer.parseInt(input[1]);
        String description = input[2];

        Genre.listAll().forEach(System.out::println);

        String g = UserInput.get("Enter genre ids for movie [1;8;9;....]");

        Set<Genre> genres = new HashSet<>();

        for (String entry : g.split(";")){
            int id = Integer.parseInt(entry);
            genres.add(Genre.read(id));
        }

        Movie movie = new Movie();
        movie.setName(name);
        movie.setLength(length);
        movie.setDescription(description);
        movie.addGenres(genres);

        UserInput.success(movie.create());
    }

    public static void updateMovie(){
        String input = UserInput.get("Enter movie ID you would like to edit");
        int id = Integer.parseInt(input);

        Movie movie = Movie.read(id);

        if (movie == null){
            System.out.println("No such movie ID found");
            return;
        }

        String option = UserInput.get("Pick what you would like to edit:\n" +
                "1. Name\n" +
                "2. Length\n" +
                "3. Description\n" +
                "4. Genres");

        switch (option){
            case "1": updateMovieName(movie); break;
            case "2": updateMovieLength(movie); break;
            case "3": updateMovieDescription(movie); break;
            case "4": updateMovieGenres(movie); break;
            default: UserInput.badInput();
        }
    }

    public static void updateMovieName(Movie movie) {
        String name = UserInput.get("Enter new movie name");
        movie.setName(name);
        UserInput.success(movie.update());
    }

    public static void updateMovieLength(Movie movie) {
        String input = UserInput.get("Enter new movie length in minutes");
        movie.setLength(Integer.parseInt(input));
        UserInput.success(movie.update());
    }

    public static void updateMovieDescription (Movie movie){
        String description = UserInput.get("Enter new movie description");
        movie.setDescription(description);
        UserInput.success(movie.update());
    }

    public static void updateMovieGenres (Movie movie) {
        String ids = UserInput.get("Enter new movie genre IDs [1;2;7;...");

        Set<Genre> genres = new HashSet<>();

        for (String id : ids.split(";")){
            Genre genre = Genre.read(Integer.parseInt(id));
            if (genre == null) {
                System.out.println("No such genre ID found");
                return;
            }

            genres.add(genre);
        }
        movie.setGenres(genres);
        UserInput.success(movie.update());
    }

    public static void detailPrint (){
        String input = UserInput.get("Enter movie to find");

        List<Object> movie = Movie.readDetailed(Integer.parseInt(input));

        if (movie == null) {
            System.out.println("No such movie ID found");
            return;
        }

        System.out.println(movie.get(0));
        System.out.println("Movies screenings:");
        List<Screening> screenings = (List<Screening>) movie.get(1);
        screenings.forEach(System.out::println);
    }

    public static void deleteMovie() {
        long id = Long.parseLong(UserInput.get("Enter movie ID"));

        Movie movie = Movie.read(id);

        if (movie == null){
            System.out.println("No such movie ID found");
            return;
        }

        UserInput.success(movie.delete());
    }
}
