package main.java.ui;

import main.java.rdg.Price;

public class PriceMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION:\n" +
                "1. Add new price\n" +
                "2. List all prices\n" +
                "3. Update price value" +
                "4. Delete price\n" +
                "Press enter to exit...";

        String input = UserInput.get(menuStr);

        switch (input) {
            case "1": addPrice(); break;
            case "2": Price.listAll().forEach(System.out::println); break;
            case "3": updatePrice(); break;
            case "4": deletePrice(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addPrice() {
        double val = Double.parseDouble(UserInput.get("Enter price value"));

        String customerType = UserInput.get("Enter customer type [CHILD/STUDENT/ADULT/SENIOR]");
        String screenType = UserInput.get("Enter halls screen type [BASIC/THREE_DIMENSIONAL/SUPER_SCREEN]");

        Price price = new Price();
        price.setCustomerType(customerType);
        price.setScreeningType(screenType);
        price.setValue(val);

        UserInput.success(price.create());
    }

    public static void updatePrice() {
        long id = Long.parseLong(UserInput.get("Enter price ID"));

        Price price = Price.read(id);

        if (price == null){
            System.out.println("No such price ID found");
            return;
        }

        double val = Double.parseDouble(UserInput.get("Enter price value"));
        price.setValue(val);
        UserInput.success(price.update());
    }

    public static void deletePrice() {
        long id = Long.parseLong(UserInput.get("Enter price ID"));

        Price price = Price.read(id);

        if (price == null){
            System.out.println("No such price ID found");
            return;
        }

        UserInput.success(price.delete());
    }
}
