package main.java.ui;

import main.java.rdg.CinemaHall;
import main.java.rdg.Movie;
import main.java.rdg.Screening;
import java.sql.Timestamp;

public class ScreeningMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION:\n" +
                "1. Add new screening\n" +
                "2. List all\n" +
                "3. Find screening\n" +
                "4. Update screening time\n" +
                "5. Delete screening\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input){
            case "1" : addScreening(); break;
            case "2" : Screening.listAll().forEach(System.out::println); break;
            case "3" : findScreening(); break;
            case "4" : updateScreening(); break;
            case "5" : deleteScreening(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addScreening() {
        long movieID = Long.parseLong(UserInput.get("Enter movie ID"));

        Movie movie = Movie.read(movieID);

        if (movie == null){
            System.out.println("No such movie ID found");
            return;
        }

        long hallID = Long.parseLong(UserInput.get("Enter hall ID"));

        CinemaHall hall = CinemaHall.read(hallID);

        if (hall == null){
            System.out.println("No such hall ID found");
            return;
        }

        String[] date = UserInput.get("Enter screening date and time [YYYY:MM:DD:HH:MM]").split(":");

        Timestamp time = new Timestamp(Integer.parseInt(date[0]) - 1900, Integer.parseInt(date[1]) - 1,
                Integer.parseInt(date[2]), Integer.parseInt(date[3]), Integer.parseInt(date[4]), 0, 0);

        Screening screening = new Screening();
        screening.setMovie(movieID);
        screening.setCinemaHall(hallID);
        screening.setTimestamp(time);

        UserInput.success(screening.create());
    }

    public static void findScreening() {
        long id = Long.parseLong(UserInput.get("Enter screening ID"));

        Screening screening = Screening.read(id);

        if (screening == null) {
            System.out.println("No such screening ID found");
            return;
        }

        System.out.println(screening);
    }

    public static void updateScreening() {
        long id = Long.parseLong(UserInput.get("Enter screening ID"));

        Screening screening = Screening.read(id);

        if (screening == null) {
            System.out.println("No such screening ID found");
            return;
        }

        String[] date = UserInput.get("Enter screening date and time [YYYY:MM:DD:HH:MM]").split(":");

        Timestamp time = new Timestamp(Integer.parseInt(date[0]) - 1900, Integer.parseInt(date[1]),
                Integer.parseInt(date[2]), Integer.parseInt(date[3]), Integer.parseInt(date[4]), 0, 0);

        screening.setTimestamp(time);

        UserInput.success(screening.update());
    }

    public static void deleteScreening() {
        long id = Long.parseLong(UserInput.get("Enter screening ID"));

        Screening screening = Screening.read(id);

        if (screening == null) {
            System.out.println("No such screening ID found");
            return;
        }

        UserInput.success(screening.delete());
    }
}
