package main.java.ui;

import main.java.RevenueObj;
import main.java.rdg.Genre;
import main.java.rdg.Voucher;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

public class StatisticsMenu {
    public static void run(){
        String menuStr = "" +
                "SELECT OPTION:\n" +
                "1. Monthly revenue of genres (last month)\n" +
                "2. Top movie revenues by genres (last 6 months)\n" +
                "3. Total month revenue\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input) {
            case "1": lastMonthRevenue(); break;
            case "2": topMoviesRevenue(); break;
            case "3": monthRevenue(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void lastMonthRevenue() {
        List<RevenueObj> revenueObjs = Voucher.Statistics.monthGenreRevenue();
        double revenueSum = 0;
        for (RevenueObj gr : revenueObjs) {
            revenueSum += gr.revenue();
            System.out.println(gr.genre() + " : " + gr.revenue() + "€");
        }
        System.out.println("\nTotal revenue : " + revenueSum + "€");
    }

    public static void topMoviesRevenue() {
        LocalDate date = LocalDate.now();
        int year = date.getYear();
        int month = date.getMonthValue();

        Set<Genre> genres = Genre.listAll();

        for (int i = 0 ; i < 6 ; i++){
            month--;
            if (month == 0) {
                month = 12;
                year--;
            }
            System.out.println(">>>>>  Revenue for " + year + "/" + month + "  <<<<<<");
            List<RevenueObj> rev;

            for (Genre g : genres){
                rev = Voucher.Statistics.topMovieRevenueByGenre(month, year, g.getName());
                if (rev.size() > 0){
                    System.out.println("------" + g.getName() + "------");
                    rev.forEach(r -> System.out.println(r.genre() + " : " + r.revenue() + "€"));
                }
            }
            System.out.println();
        }
    }

    public static void monthRevenue() {
        String[] input = UserInput.get("Enter year and month [YYYY:MM]").split(":");

        int year = Integer.parseInt(input[0]);
        int month = Integer.parseInt(input[1]);

        double revenue = Voucher.Statistics.monthRevenue(month, year);
        System.out.println("Revenue for " + year + "/" + month + " : " + revenue + "€");
    }
}
